/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.dataflow;

import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.dataflow.DFALimitExceededException;
import com.intellij.codeInsight.dataflow.DfaInstance;
import com.intellij.codeInsight.dataflow.Semilattice;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class DFAEngine<E> {
    private static final Logger LOG = Logger.getInstance((String)DFAEngine.class.getName());
    private static final double TIME_LIMIT = 1.0E10;
    private final Instruction[] myFlow;
    private final DfaInstance<E> myDfa;
    private final Semilattice<E> mySemilattice;

    public DFAEngine(Instruction[] flow, DfaInstance<E> dfa, Semilattice<E> semilattice) {
        this.myFlow = flow;
        this.myDfa = dfa;
        this.mySemilattice = semilattice;
    }

    public List<E> performDFA() throws DFALimitExceededException {
        ArrayList info = new ArrayList(this.myFlow.length);
        return this.performDFA(info);
    }

    /*
     * Unable to fully structure code
     */
    public List<E> performDFA(List<E> info) throws DFALimitExceededException {
        if (DFAEngine.LOG.isDebugEnabled()) {
            DFAEngine.LOG.debug("Performing DFA\nInstance: " + this.myDfa + " Semilattice: " + this.mySemilattice + "\nCon");
        }
        initial = this.myDfa.initial();
        for (i = 0; i < this.myFlow.length; ++i) {
            info.add(i, initial);
        }
        visited = new boolean[this.myFlow.length];
        forward = this.myDfa.isForward();
        order = ControlFlowUtil.postOrder(this.myFlow);
        limit = this.getIterationLimit(forward);
        dfaCount = 0;
        startTime = System.nanoTime();
        v0 = i = forward != false ? 0 : this.myFlow.length - 1;
        while (forward != false ? i < this.myFlow.length : i >= 0) {
            ProgressManager.checkCanceled();
            if ((double)(System.nanoTime() - startTime) > 1.0E10) {
                if (DFAEngine.LOG.isDebugEnabled()) {
                    DFAEngine.LOG.debug("Time limit exceeded");
                }
                throw new DFALimitExceededException("Time limit exceeded");
            }
            count = 0;
            instruction = this.myFlow[order[i]];
            number = instruction.num();
            if (!visited[number]) {
                worklist = new LinkedList<Instruction>();
                worklist.add(instruction);
                visited[number] = true;
                block2: while (true) {
                    ProgressManager.checkCanceled();
                    if (++count > limit) {
                        if (DFAEngine.LOG.isDebugEnabled()) {
                            DFAEngine.LOG.debug("Iteration count exceeded on worklist");
                        }
                        throw new DFALimitExceededException("Iteration count exceeded on worklist");
                    }
                    currentInstruction = (Instruction)worklist.poll();
                    if (currentInstruction == null) break;
                    currentNumber = currentInstruction.num();
                    oldE = info.get(currentNumber);
                    joinedE = this.join(currentInstruction, info);
                    newE = this.myDfa.fun(joinedE, currentInstruction);
                    if (this.mySemilattice.eq(newE, oldE)) continue;
                    if (DFAEngine.LOG.isDebugEnabled()) {
                        DFAEngine.LOG.debug("Number: " + currentNumber + " old: " + oldE.toString() + " new: " + newE.toString());
                    }
                    info.set(currentNumber, newE);
                    var20_20 = this.getNext(currentInstruction).iterator();
                    while (true) {
                        if (var20_20.hasNext()) ** break;
                        continue block2;
                        next = var20_20.next();
                        worklist.add(next);
                        visited[next.num()] = true;
                    }
                    break;
                }
            }
            i = forward ? ++i : --i;
            dfaCount += count;
        }
        if (DFAEngine.LOG.isDebugEnabled()) {
            DFAEngine.LOG.debug("Done in: " + (double)(System.nanoTime() - startTime) / 1.0E7 + "ms. Ratio: " + dfaCount / this.myFlow.length);
        }
        return info;
    }

    private int getIterationLimit(boolean forward) {
        int allPred = this.myFlow.length;
        for (Instruction instruction : this.myFlow) {
            allPred += forward ? instruction.allPred().size() : instruction.allSucc().size();
        }
        return allPred * 2;
    }

    private E join(Instruction instruction, List<E> info) {
        Collection prev = this.myDfa.isForward() ? instruction.allPred() : instruction.allSucc();
        ArrayList<E> prevInfos = new ArrayList<E>();
        for (Instruction i : prev) {
            prevInfos.add(info.get(i.num()));
        }
        return this.mySemilattice.join(prevInfos);
    }

    private Collection<Instruction> getNext(Instruction curr) {
        return this.myDfa.isForward() ? curr.allSucc() : curr.allPred();
    }
}

