/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.generation.surroundWith.JavaExpressionSurrounder;
import com.intellij.codeInsight.generation.surroundWith.JavaWithCastSurrounder;
import com.intellij.codeInsight.generation.surroundWith.JavaWithIfElseExpressionSurrounder;
import com.intellij.codeInsight.generation.surroundWith.JavaWithIfExpressionSurrounder;
import com.intellij.codeInsight.generation.surroundWith.JavaWithNotInstanceofSurrounder;
import com.intellij.codeInsight.generation.surroundWith.JavaWithNotSurrounder;
import com.intellij.codeInsight.generation.surroundWith.JavaWithNullCheckSurrounder;
import com.intellij.codeInsight.generation.surroundWith.JavaWithParenthesesSurrounder;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class JavaExpressionSurroundDescriptor
implements SurroundDescriptor {
    private Surrounder[] mySurrounders = null;
    private static final Surrounder[] SURROUNDERS = new Surrounder[]{new JavaWithParenthesesSurrounder(), new JavaWithCastSurrounder(), new JavaWithNotSurrounder(), new JavaWithNotInstanceofSurrounder(), new JavaWithIfExpressionSurrounder(), new JavaWithIfElseExpressionSurrounder(), new JavaWithNullCheckSurrounder()};

    @NotNull
    public PsiElement[] getElementsToSurround(PsiFile file, int startOffset, int endOffset) {
        PsiExpression expr = CodeInsightUtil.findExpressionInRange(file, startOffset, endOffset);
        if (expr == null && (expr = IntroduceVariableBase.getSelectedExpression(file.getProject(), file, startOffset, endOffset)) == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/surroundWith/JavaExpressionSurroundDescriptor", "getElementsToSurround"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.surroundwith.expression");
        PsiElement[] psiElementArray = new PsiElement[]{expr};
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/surroundWith/JavaExpressionSurroundDescriptor", "getElementsToSurround"));
        }
        return psiElementArray;
    }

    @NotNull
    public Surrounder[] getSurrounders() {
        if (this.mySurrounders == null) {
            ArrayList list = new ArrayList();
            Collections.addAll(list, SURROUNDERS);
            Collections.addAll(list, Extensions.getExtensions((ExtensionPointName)JavaExpressionSurrounder.EP_NAME));
            this.mySurrounders = list.toArray(new Surrounder[list.size()]);
        }
        if (this.mySurrounders == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/surroundWith/JavaExpressionSurroundDescriptor", "getSurrounders"));
        }
        return this.mySurrounders;
    }

    public boolean isExclusive() {
        return false;
    }
}

