/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiStatement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class SwapIfStatementsIntentionAction
extends PsiElementBaseIntentionAction {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/SwapIfStatementsIntentionAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/SwapIfStatementsIntentionAction", "invoke"));
        }
        PsiIfStatement ifStatement = (PsiIfStatement)element.getParent();
        PsiIfStatement nestedIfStatement = (PsiIfStatement)ifStatement.getElseBranch();
        assert (nestedIfStatement != null);
        PsiExpression condition = ifStatement.getCondition();
        PsiExpression nestedCondition = nestedIfStatement.getCondition();
        PsiStatement thenBranch = ifStatement.getThenBranch();
        PsiStatement nestedThenBranch = nestedIfStatement.getThenBranch();
        assert (condition != null);
        assert (nestedCondition != null);
        assert (thenBranch != null);
        assert (nestedThenBranch != null);
        PsiElement conditionCopy = condition.copy();
        condition.replace((PsiElement)nestedCondition);
        nestedCondition.replace(conditionCopy);
        PsiElement thenBranchCopy = thenBranch.copy();
        thenBranch.replace((PsiElement)nestedThenBranch);
        nestedThenBranch.replace(thenBranchCopy);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/SwapIfStatementsIntentionAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/SwapIfStatementsIntentionAction", "isAvailable"));
        }
        if (!(element instanceof PsiKeyword) || !"else".equals(element.getText())) {
            return false;
        }
        PsiElement parent = element.getParent();
        return parent instanceof PsiIfStatement && ((PsiIfStatement)parent).getElseBranch() instanceof PsiIfStatement;
    }

    @NotNull
    public String getFamilyName() {
        if ("Swap 'if' statements" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/SwapIfStatementsIntentionAction", "getFamilyName"));
        }
        return "Swap 'if' statements";
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/SwapIfStatementsIntentionAction", "getText"));
        }
        return string;
    }
}

