/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.TemplateOptionalProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.Nls;

public class CodeBlockReformattingProcessor
implements TemplateOptionalProcessor {
    @Override
    public void processText(Project project, Template template, Document document, RangeMarker templateRange, Editor editor) {
        PsiJavaToken rBrace;
        PsiCodeBlock codeBlock;
        if (!template.isToReformat()) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        PsiFile file = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        if (!(file instanceof PsiJavaFile)) {
            return;
        }
        CharSequence text = document.getImmutableCharSequence();
        int prevChar = CharArrayUtil.shiftBackward((CharSequence)text, (int)(templateRange.getStartOffset() - 1), (String)" \t");
        int nextChar = CharArrayUtil.shiftForward((CharSequence)text, (int)templateRange.getEndOffset(), (String)" \t");
        if (prevChar > 0 && text.charAt(prevChar) == '{' && nextChar < text.length() && text.charAt(nextChar) == '}' && (codeBlock = (PsiCodeBlock)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)prevChar, PsiCodeBlock.class, (boolean)false)) != null && codeBlock.getTextRange().getStartOffset() == prevChar && (rBrace = codeBlock.getRBrace()) != null && rBrace.getTextRange().getStartOffset() == nextChar) {
            CodeEditUtil.markToReformat(rBrace.getNode(), true);
        }
    }

    @Override
    @Nls
    public String getOptionName() {
        return "Please report a bug";
    }

    @Override
    public boolean isEnabled(Template template) {
        return true;
    }

    @Override
    public void setEnabled(Template template, boolean value) {
    }

    @Override
    public boolean isVisible(Template template) {
        return false;
    }
}

