/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.options.AnnotationProcessorsPanel;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;

public class AnnotationProcessorsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private final Project myProject;
    private AnnotationProcessorsPanel myMainPanel;

    public AnnotationProcessorsConfigurable(Project project) {
        this.myProject = project;
    }

    public String getDisplayName() {
        return "Annotation Processors";
    }

    public String getHelpTopic() {
        return "reference.projectsettings.compiler.annotationProcessors";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/options/AnnotationProcessorsConfigurable", "getId"));
        }
        return string;
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    public JComponent createComponent() {
        this.myMainPanel = new AnnotationProcessorsPanel(this.myProject);
        return this.myMainPanel;
    }

    public boolean isModified() {
        CompilerConfigurationImpl config = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)this.myProject);
        if (!config.getDefaultProcessorProfile().equals(this.myMainPanel.getDefaultProfile())) {
            return true;
        }
        HashMap<String, ProcessorConfigProfile> configProfiles = new HashMap<String, ProcessorConfigProfile>();
        for (ProcessorConfigProfile profile : config.getModuleProcessorProfiles()) {
            configProfiles.put(profile.getName(), profile);
        }
        List<ProcessorConfigProfile> panelProfiles = this.myMainPanel.getModuleProfiles();
        if (configProfiles.size() != panelProfiles.size()) {
            return true;
        }
        for (ProcessorConfigProfile panelProfile : panelProfiles) {
            ProcessorConfigProfile configProfile = (ProcessorConfigProfile)configProfiles.get(panelProfile.getName());
            if (configProfile != null && configProfile.equals(panelProfile)) continue;
            return true;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        CompilerConfigurationImpl config = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)this.myProject);
        config.setDefaultProcessorProfile(this.myMainPanel.getDefaultProfile());
        config.setModuleProcessorProfiles(this.myMainPanel.getModuleProfiles());
    }

    public void reset() {
        CompilerConfigurationImpl config = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)this.myProject);
        this.myMainPanel.initProfiles(config.getDefaultProcessorProfile(), config.getModuleProcessorProfiles());
    }

    public void disposeUIResources() {
        this.myMainPanel = null;
    }
}

