/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.StateMap;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.containers.SmartHashSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.ArraysKt;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"%\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001bB\u0003\u0001\u000b\u0005A!#B\u0001\u0005\u0003\u0015\t\u0001\"E\u0003\u0002\t\u0005i\u0019\u0004\u0003\u0001\u000e\u00051\u0005\u0001\u0014A\r\u0004\u0011\u0005i\u0011\u0001g\u0001\u001a\u0007!\u0011Q\"\u0001M\u00033-!\u0011\u0001C\u0002\u000e\u0011%\u0011\u0011\"\u0001M\u0003\u0013\tI\u0011\u0001'\u0001\r\u0002a\u001dAk\u0001\u0003\u000e!\u0011\t\u0001\u0012B\u0007\u0005\u0013\tI\u0011\u0001'\u0002\u0019\u000bU\t\u00014AM\u0005\u0011\u0017i\u0011\u0001g\u0001Q\u0007\u0003!6\u0001BG\u0007\u0011\u0019i\u0011\u0001'\u0001\u0016\u0003a\u0005Ak\u0001\u0003"}, strings={"save", "Lorg/jdom/Element;", "states", "Lcom/intellij/configurationStore/StateMap;", "rootElementName", "", "newLiveStates", "", "XmlElementStorageKt", "getChangedComponentNames", "", "newStates", "normalizeRootName"}, moduleName="configuration-store-impl")
public final class XmlElementStorageKt {
    @Nullable
    public static final Element save(@NotNull StateMap states, @NotNull String rootElementName, @Nullable Map<String, ? extends Element> newLiveStates) {
        Intrinsics.checkParameterIsNotNull((Object)states, (String)"states");
        Intrinsics.checkParameterIsNotNull((Object)rootElementName, (String)"rootElementName");
        if (states.isEmpty()) {
            return null;
        }
        Element rootElement = new Element(rootElementName);
        String[] stringArray = states.keys();
        for (int i = 0; i < stringArray.length; ++i) {
            String componentName = stringArray[i];
            Element element = states.getElement(componentName, newLiveStates);
            List elementAttributes = element.getAttributes();
            if (elementAttributes.isEmpty()) {
                element.setAttribute("name", componentName);
            } else {
                Attribute nameAttribute = element.getAttribute("name");
                if (nameAttribute == null) {
                    nameAttribute = new Attribute("name", componentName);
                    elementAttributes.add(0, nameAttribute);
                } else {
                    nameAttribute.setValue(componentName);
                    if (Intrinsics.areEqual((Object)((Attribute)elementAttributes.get(0)), (Object)nameAttribute) ^ true) {
                        elementAttributes.remove(nameAttribute);
                        elementAttributes.add(0, nameAttribute);
                    }
                }
            }
            rootElement.addContent(element);
        }
        return rootElement;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ Element save$default(StateMap stateMap, String string, Map map, int n) {
        if ((n & 4) != 0) {
            map = null;
        }
        return XmlElementStorageKt.save(stateMap, string, map);
    }

    @NotNull
    public static final Element normalizeRootName(Element $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver.getParent() != null) {
            ComponentStoreImplKt.getLOG().warn("State element must not have parent " + JDOMUtil.writeElement((Element)$receiver));
            $receiver.detach();
        }
        $receiver.setName("component");
        return $receiver;
    }

    private static final Set<String> getChangedComponentNames(StateMap $receiver, StateMap newStates) {
        Set bothStates = ArraysKt.toMutableSet((Object[])$receiver.keys());
        CollectionsKt.retainAll((Collection)bothStates, (Object[])newStates.keys());
        SmartHashSet diffs = new SmartHashSet();
        CollectionsKt.addAll((Collection)((Collection)diffs), (Object[])newStates.keys());
        CollectionsKt.addAll((Collection)((Collection)diffs), (Object[])$receiver.keys());
        diffs.removeAll((Collection)bothStates);
        for (String componentName : bothStates) {
            $receiver.compare(componentName, newStates, (Set)diffs);
        }
        return (Set)diffs;
    }

    @NotNull
    public static final /* synthetic */ Set<String> access$getChangedComponentNames(StateMap $receiver, @NotNull StateMap newStates) {
        return XmlElementStorageKt.getChangedComponentNames($receiver, newStates);
    }
}

