/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.FrameExtraVariablesProvider;
import com.intellij.debugger.engine.JavaDebuggerEvaluator;
import com.intellij.debugger.engine.JavaFramesListRenderer;
import com.intellij.debugger.engine.JavaStaticGroup;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.DecompiledLocalVariable;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.LocalVariablesUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StaticDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaStackFrame
extends XStackFrame {
    private static final Logger LOG = Logger.getInstance(JavaStackFrame.class);
    private final DebugProcessImpl myDebugProcess;
    @Nullable
    private final XSourcePosition myXSourcePosition;
    private final NodeManagerImpl myNodeManager;
    @NotNull
    private final StackFrameDescriptorImpl myDescriptor;
    private static final JavaFramesListRenderer FRAME_RENDERER = new JavaFramesListRenderer();
    private JavaDebuggerEvaluator myEvaluator;
    private final String myEqualityObject;
    private static final Pair<Set<String>, Set<TextWithImports>> EMPTY_USED_VARS = Pair.create(Collections.emptySet(), Collections.emptySet());

    public JavaStackFrame(@NotNull StackFrameDescriptorImpl descriptor, boolean update) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/debugger/engine/JavaStackFrame", "<init>"));
        }
        this.myEvaluator = null;
        this.myDescriptor = descriptor;
        if (update) {
            this.myDescriptor.setContext(null);
            this.myDescriptor.updateRepresentation(null, DescriptorLabelListener.DUMMY_LISTENER);
        }
        this.myEqualityObject = update ? NodeManagerImpl.getContextKeyForFrame(this.myDescriptor.getFrameProxy()) : null;
        this.myDebugProcess = (DebugProcessImpl)descriptor.getDebugProcess();
        this.myNodeManager = this.myDebugProcess.getXdebugProcess().getNodeManager();
        this.myXSourcePosition = this.myDescriptor.getSourcePosition() != null ? DebuggerUtilsEx.toXSourcePosition(this.myDescriptor.getSourcePosition()) : null;
    }

    @NotNull
    public StackFrameDescriptorImpl getDescriptor() {
        StackFrameDescriptorImpl stackFrameDescriptorImpl = this.myDescriptor;
        if (stackFrameDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JavaStackFrame", "getDescriptor"));
        }
        return stackFrameDescriptorImpl;
    }

    @Nullable
    public XDebuggerEvaluator getEvaluator() {
        if (this.myEvaluator == null) {
            this.myEvaluator = new JavaDebuggerEvaluator(this.myDebugProcess, this);
        }
        return this.myEvaluator;
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.myXSourcePosition;
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        XStackFrame frame;
        XDebugSession xSession;
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/debugger/engine/JavaStackFrame", "customizePresentation"));
        }
        StackFrameDescriptorImpl selectedDescriptor = null;
        DebuggerSession session = this.myDebugProcess.getSession();
        if (session != null && (xSession = session.getXDebugSession()) != null && (frame = xSession.getCurrentStackFrame()) instanceof JavaStackFrame) {
            selectedDescriptor = ((JavaStackFrame)frame).getDescriptor();
        }
        FRAME_RENDERER.customizePresentation(this.myDescriptor, component, selectedDescriptor);
    }

    public void computeChildren(final @NotNull XCompositeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/debugger/engine/JavaStackFrame", "computeChildren"));
        }
        if (node.isObsolete()) {
            return;
        }
        this.myDebugProcess.getManagerThread().schedule(new DebuggerContextCommandImpl(this.myDebugProcess.getDebuggerContext(), this.myDescriptor.getFrameProxy().threadProxy()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            @Override
            public void threadAction() {
                if (node.isObsolete()) {
                    return;
                }
                XValueChildrenList children2 = new XValueChildrenList();
                JavaStackFrame.this.buildVariablesThreadAction(JavaStackFrame.this.getFrameDebuggerContext(), children2, node);
                node.addChildren(children2, true);
            }
        });
    }

    DebuggerContextImpl getFrameDebuggerContext() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        DebuggerContextImpl context = this.myDebugProcess.getDebuggerContext();
        if (context.getFrameProxy() != this.getStackFrameProxy()) {
            SuspendContextImpl threadSuspendContext = SuspendManagerUtil.getSuspendContextForThread(context.getSuspendContext(), this.getStackFrameProxy().threadProxy());
            context = DebuggerContextImpl.createDebuggerContext(this.myDebugProcess.mySession, threadSuspendContext, this.getStackFrameProxy().threadProxy(), this.getStackFrameProxy());
            context.setPositionCache(this.myDescriptor.getSourcePosition());
            context.initCaches();
        }
        return context;
    }

    private void buildVariablesThreadAction(DebuggerContextImpl debuggerContext, XValueChildrenList children2, XCompositeNode node) {
        try {
            StaticDescriptorImpl staticDecriptor;
            EvaluationContextImpl evaluationContext = debuggerContext.createEvaluationContext();
            if (evaluationContext == null) {
                return;
            }
            if (!debuggerContext.isEvaluationPossible()) {
                node.setErrorMessage(MessageDescriptor.EVALUATION_NOT_POSSIBLE.getLabel());
            }
            Location location = this.myDescriptor.getLocation();
            ObjectReference thisObjectReference = this.myDescriptor.getThisObject();
            if (thisObjectReference != null) {
                ValueDescriptorImpl thisDescriptor = this.myNodeManager.getThisDescriptor(null, thisObjectReference);
                children2.add((XNamedValue)JavaValue.create(thisDescriptor, evaluationContext, this.myNodeManager));
            } else if (location != null && (staticDecriptor = this.myNodeManager.getStaticDescriptor(this.myDescriptor, location.declaringType())).isExpandable()) {
                children2.addTopGroup((XValueGroup)new JavaStaticGroup(staticDecriptor, evaluationContext, this.myNodeManager));
            }
            DebugProcessImpl debugProcess = debuggerContext.getDebugProcess();
            if (debugProcess == null) {
                return;
            }
            Pair<Method, Value> methodValuePair = debugProcess.getLastExecutedMethod();
            if (methodValuePair != null) {
                ValueDescriptorImpl returnValueDescriptor = this.myNodeManager.getMethodReturnValueDescriptor(this.myDescriptor, (Method)methodValuePair.getFirst(), (Value)methodValuePair.getSecond());
                children2.add((XNamedValue)JavaValue.create(returnValueDescriptor, evaluationContext, this.myNodeManager));
            }
            for (Pair<Breakpoint, Event> pair : DebuggerUtilsEx.getEventDescriptors(debuggerContext.getSuspendContext())) {
                ObjectReference exception;
                Event debugEvent = (Event)pair.getSecond();
                if (!(debugEvent instanceof ExceptionEvent) || (exception = ((ExceptionEvent)debugEvent).exception()) == null) continue;
                ValueDescriptorImpl exceptionDescriptor = this.myNodeManager.getThrownExceptionObjectDescriptor(this.myDescriptor, exception);
                children2.add((XNamedValue)JavaValue.create(exceptionDescriptor, evaluationContext, this.myNodeManager));
            }
            try {
                this.buildVariables(debuggerContext, evaluationContext, debugProcess, children2, thisObjectReference, location);
            }
            catch (EvaluateException e) {
                node.setErrorMessage(e.getMessage());
            }
        }
        catch (InvalidStackFrameException e) {
            LOG.info((Throwable)e);
        }
        catch (InternalException e) {
            if (e.errorCode() == 35) {
                node.setErrorMessage(DebuggerBundle.message((String)"error.corrupt.debug.info", (Object[])new Object[]{e.getMessage()}));
            }
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void buildVariables(DebuggerContextImpl debuggerContext, EvaluationContextImpl evaluationContext, @NotNull DebugProcessImpl debugProcess, XValueChildrenList children2, ObjectReference thisObjectReference, Location location) throws EvaluateException {
        block17: {
            ReferenceType thisRefType;
            if (debugProcess == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/engine/JavaStackFrame", "buildVariables"));
            }
            final HashSet<String> visibleLocals = new HashSet<String>();
            if (NodeRendererSettings.getInstance().getClassRenderer().SHOW_VAL_FIELDS_AS_LOCAL_VARIABLES && thisObjectReference != null && debugProcess.getVirtualMachineProxy().canGetSyntheticAttribute() && (thisRefType = thisObjectReference.referenceType()) instanceof ClassType && location != null && thisRefType.equals(location.declaringType()) && thisRefType.name().contains("$")) {
                for (Field field : thisRefType.fields()) {
                    if (!DebuggerUtils.isSynthetic((TypeComponent)field) || !StringUtil.startsWith((CharSequence)field.name(), (CharSequence)"val$")) continue;
                    FieldDescriptorImpl fieldDescriptorImpl = this.myNodeManager.getFieldDescriptor(this.myDescriptor, thisObjectReference, field);
                    children2.add((XNamedValue)JavaValue.create(fieldDescriptorImpl, evaluationContext, this.myNodeManager));
                    visibleLocals.add(fieldDescriptorImpl.calcValueName());
                }
            }
            boolean myAutoWatchMode = DebuggerSettings.getInstance().AUTO_VARIABLES_MODE;
            if (evaluationContext == null) {
                return;
            }
            try {
                if (!XDebuggerSettingsManager.getInstance().getDataViewSettings().isAutoExpressions() && !myAutoWatchMode) {
                    this.superBuildVariables(evaluationContext, children2);
                } else {
                    void var11_17;
                    final SourcePosition sourcePosition = debuggerContext.getSourcePosition();
                    final Map visibleVariables = ContainerUtil.map2Map(this.getVisibleVariables(), (Function)new Function<LocalVariableProxyImpl, Pair<String, LocalVariableProxyImpl>>(){

                        public Pair<String, LocalVariableProxyImpl> fun(LocalVariableProxyImpl var) {
                            return Pair.create((Object)var.name(), (Object)var);
                        }
                    });
                    Pair<Set<String>, Set<TextWithImports>> pair = EMPTY_USED_VARS;
                    if (sourcePosition != null) {
                        Pair pair2 = (Pair)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Pair<Set<String>, Set<TextWithImports>>>(){

                            public Pair<Set<String>, Set<TextWithImports>> compute() {
                                return JavaStackFrame.findReferencedVars(ContainerUtil.union(visibleVariables.keySet(), (Set)visibleLocals), sourcePosition);
                            }
                        });
                    }
                    if (myAutoWatchMode) {
                        for (String var : (Set)var11_17.first) {
                            LocalVariableProxyImpl local = (LocalVariableProxyImpl)visibleVariables.get(var);
                            if (local == null) continue;
                            children2.add((XNamedValue)JavaValue.create(this.myNodeManager.getLocalVariableDescriptor(null, local), evaluationContext, this.myNodeManager));
                        }
                    } else {
                        this.superBuildVariables(evaluationContext, children2);
                    }
                    EvaluationContextImpl evalContextCopy = evaluationContext.createEvaluationContext(evaluationContext.getThisObject());
                    evalContextCopy.setAutoLoadClasses(false);
                    if (sourcePosition != null) {
                        Set<TextWithImports> extraVars = JavaStackFrame.computeExtraVars((Pair<Set<String>, Set<TextWithImports>>)var11_17, sourcePosition, evaluationContext);
                        this.addToChildrenFrom(extraVars, children2, evaluationContext);
                    }
                    this.addToChildrenFrom((Set)var11_17.second, children2, evalContextCopy);
                }
            }
            catch (EvaluateException e) {
                if (e.getCause() instanceof AbsentInformationException) {
                    children2.add((XNamedValue)new DummyMessageValueNode(MessageDescriptor.LOCAL_VARIABLES_INFO_UNAVAILABLE.getLabel(), XDebuggerUIConstants.INFORMATION_MESSAGE_ICON));
                    try {
                        for (Map.Entry entry : LocalVariablesUtil.fetchValues(this.getStackFrameProxy(), debugProcess).entrySet()) {
                            children2.add((XNamedValue)JavaValue.create(this.myNodeManager.getArgumentValueDescriptor(null, (DecompiledLocalVariable)entry.getKey(), (Value)entry.getValue()), evaluationContext, this.myNodeManager));
                        }
                    }
                    catch (Exception ex) {
                        LOG.info((Throwable)ex);
                        break block17;
                    }
                }
                throw e;
            }
        }
    }

    private static Set<TextWithImports> computeExtraVars(Pair<Set<String>, Set<TextWithImports>> usedVars, @NotNull SourcePosition sourcePosition, @NotNull EvaluationContextImpl evalContext) {
        if (sourcePosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourcePosition", "com/intellij/debugger/engine/JavaStackFrame", "computeExtraVars"));
        }
        if (evalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evalContext", "com/intellij/debugger/engine/JavaStackFrame", "computeExtraVars"));
        }
        HashSet<String> alreadyCollected = new HashSet<String>((Collection)usedVars.first);
        for (TextWithImports text : (Set)usedVars.second) {
            alreadyCollected.add(text.getText());
        }
        HashSet<TextWithImports> extra = new HashSet<TextWithImports>();
        for (FrameExtraVariablesProvider provider : (FrameExtraVariablesProvider[])FrameExtraVariablesProvider.EP_NAME.getExtensions()) {
            if (!provider.isAvailable(sourcePosition, evalContext)) continue;
            extra.addAll(provider.collectVariables(sourcePosition, evalContext, alreadyCollected));
        }
        return extra;
    }

    private void addToChildrenFrom(Set<TextWithImports> expressions, XValueChildrenList children2, EvaluationContextImpl evaluationContext) {
        for (TextWithImports text : expressions) {
            WatchItemDescriptor descriptor = this.myNodeManager.getWatchItemDescriptor(null, text, null);
            children2.add((XNamedValue)JavaValue.create(descriptor, evaluationContext, this.myNodeManager));
        }
    }

    protected void superBuildVariables(EvaluationContextImpl evaluationContext, XValueChildrenList children2) throws EvaluateException {
        for (LocalVariableProxyImpl local : this.getVisibleVariables()) {
            children2.add((XNamedValue)JavaValue.create(this.myNodeManager.getLocalVariableDescriptor(null, local), evaluationContext, this.myNodeManager));
        }
    }

    @NotNull
    public StackFrameProxyImpl getStackFrameProxy() {
        StackFrameProxyImpl stackFrameProxyImpl = this.myDescriptor.getFrameProxy();
        if (stackFrameProxyImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JavaStackFrame", "getStackFrameProxy"));
        }
        return stackFrameProxyImpl;
    }

    @Nullable
    public Object getEqualityObject() {
        return this.myEqualityObject;
    }

    public String toString() {
        if (this.myXSourcePosition != null) {
            return "JavaFrame " + this.myXSourcePosition.getFile().getName() + ":" + this.myXSourcePosition.getLine();
        }
        return "JavaFrame position unknown";
    }

    protected List<LocalVariableProxyImpl> getVisibleVariables() throws EvaluateException {
        return this.getStackFrameProxy().visibleVariables();
    }

    private static boolean shouldSkipLine(PsiFile file, Document doc, int line) {
        int start = doc.getLineStartOffset(line);
        int end = doc.getLineEndOffset(line);
        int _start = CharArrayUtil.shiftForward((CharSequence)doc.getCharsSequence(), (int)start, (String)" \n\t");
        if (_start >= end) {
            return true;
        }
        TextRange alreadyChecked = null;
        for (PsiElement elem = file.findElementAt(_start); !(elem == null || elem.getTextOffset() > end || alreadyChecked != null && alreadyChecked.contains(elem.getTextRange())); elem = elem.getNextSibling()) {
            PsiElement _elem = elem;
            while (_elem.getTextOffset() >= _start) {
                PsiElement resolved;
                alreadyChecked = _elem.getTextRange();
                if (_elem instanceof PsiDeclarationStatement) {
                    PsiElement[] declared;
                    for (PsiElement declaredElement : declared = ((PsiDeclarationStatement)_elem).getDeclaredElements()) {
                        if (!(declaredElement instanceof PsiVariable)) continue;
                        return false;
                    }
                }
                if (_elem instanceof PsiJavaCodeReferenceElement && (resolved = ((PsiJavaCodeReferenceElement)_elem).resolve()) instanceof PsiVariable) {
                    return false;
                }
                _elem = _elem.getParent();
            }
        }
        return true;
    }

    private static Pair<Set<String>, Set<TextWithImports>> findReferencedVars(Set<String> visibleVars, @NotNull SourcePosition position) {
        int offset;
        PsiElement element;
        int endLine;
        Document doc;
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/engine/JavaStackFrame", "findReferencedVars"));
        }
        int line = position.getLine();
        if (line < 0) {
            return Pair.create(Collections.emptySet(), Collections.emptySet());
        }
        PsiFile positionFile = position.getFile();
        if (!positionFile.isValid() || !positionFile.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
            return Pair.create(visibleVars, Collections.emptySet());
        }
        VirtualFile vFile = positionFile.getVirtualFile();
        Document document = doc = vFile != null ? FileDocumentManager.getInstance().getDocument(vFile) : null;
        if (doc == null || doc.getLineCount() == 0 || line > doc.getLineCount() - 1) {
            return Pair.create(Collections.emptySet(), Collections.emptySet());
        }
        TextRange limit = JavaStackFrame.calculateLimitRange(positionFile, doc, line);
        int startLine = Math.max(limit.getStartOffset(), line - 1);
        for (startLine = Math.min(startLine, limit.getEndOffset()); startLine > limit.getStartOffset() && JavaStackFrame.shouldSkipLine(positionFile, doc, startLine); --startLine) {
        }
        int startOffset = doc.getLineStartOffset(startLine);
        for (endLine = Math.min(line + 2, limit.getEndOffset()); endLine < limit.getEndOffset() && JavaStackFrame.shouldSkipLine(positionFile, doc, endLine); ++endLine) {
        }
        int endOffset = doc.getLineEndOffset(endLine);
        TextRange lineRange = new TextRange(startOffset, endOffset);
        if (!lineRange.isEmpty() && (element = positionFile.findElementAt(offset = CharArrayUtil.shiftForward((CharSequence)doc.getCharsSequence(), (int)doc.getLineStartOffset(line), (String)" \t"))) != null) {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class});
            if (method != null) {
                element = method;
            } else {
                PsiField field = (PsiField)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiField.class});
                if (field != null) {
                    element = field;
                } else {
                    PsiClassInitializer initializer = (PsiClassInitializer)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiClassInitializer.class});
                    if (initializer != null) {
                        element = initializer;
                    }
                }
            }
            if (element instanceof PsiCompiledElement) {
                return Pair.create(visibleVars, Collections.emptySet());
            }
            VariablesCollector collector = new VariablesCollector(visibleVars, JavaStackFrame.adjustRange(element, lineRange));
            element.accept((PsiElementVisitor)collector);
            return Pair.create(collector.getVars(), collector.getExpressions());
        }
        return Pair.create(Collections.emptySet(), Collections.emptySet());
    }

    private static TextRange calculateLimitRange(PsiFile file, Document doc, int line) {
        PsiMethod method;
        int offset = doc.getLineStartOffset(line);
        if (offset > 0 && (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(offset), PsiMethod.class, (boolean)false)) != null) {
            TextRange elemRange = method.getTextRange();
            return new TextRange(doc.getLineNumber(elemRange.getStartOffset()), doc.getLineNumber(elemRange.getEndOffset()));
        }
        return new TextRange(0, doc.getLineCount() - 1);
    }

    private static TextRange adjustRange(PsiElement element, final TextRange originalRange) {
        final Ref rangeRef = new Ref((Object)originalRange);
        element.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitExpressionStatement(PsiExpressionStatement statement) {
                TextRange stRange = statement.getTextRange();
                if (originalRange.intersects(stRange)) {
                    TextRange currentRange = (TextRange)rangeRef.get();
                    int start = Math.min(currentRange.getStartOffset(), stRange.getStartOffset());
                    int end = Math.max(currentRange.getEndOffset(), stRange.getEndOffset());
                    rangeRef.set((Object)new TextRange(start, end));
                }
            }
        });
        return (TextRange)rangeRef.get();
    }

    private static class VariablesCollector
    extends JavaRecursiveElementVisitor {
        private final Set<String> myVisibleLocals;
        private final TextRange myLineRange;
        private final Set<TextWithImports> myExpressions = new HashSet<TextWithImports>();
        private final Set<String> myVars = new HashSet<String>();
        private final boolean myCollectExpressions = XDebuggerSettingsManager.getInstance().getDataViewSettings().isAutoExpressions();

        public VariablesCollector(Set<String> visibleLocals, TextRange lineRange) {
            this.myVisibleLocals = visibleLocals;
            this.myLineRange = lineRange;
        }

        public Set<String> getVars() {
            return this.myVars;
        }

        public Set<TextWithImports> getExpressions() {
            return this.myExpressions;
        }

        public void visitElement(PsiElement element) {
            if (this.myLineRange.intersects(element.getTextRange())) {
                super.visitElement(element);
            }
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            PsiMethod psiMethod;
            if (this.myCollectExpressions && (psiMethod = expression.resolveMethod()) != null && !DebuggerUtils.hasSideEffectsOrReferencesMissingVars((PsiElement)expression, this.myVisibleLocals)) {
                this.myExpressions.add(new TextWithImportsImpl((PsiElement)expression));
            }
            super.visitMethodCallExpression(expression);
        }

        public void visitReferenceExpression(PsiReferenceExpression reference) {
            PsiElement psiElement;
            if (this.myLineRange.intersects(reference.getTextRange()) && (psiElement = reference.resolve()) instanceof PsiVariable) {
                PsiVariable var = (PsiVariable)psiElement;
                if (var instanceof PsiField) {
                    if (this.myCollectExpressions && !DebuggerUtils.hasSideEffectsOrReferencesMissingVars((PsiElement)reference, this.myVisibleLocals)) {
                        boolean isConstant;
                        PsiModifierList modifierList = var.getModifierList();
                        boolean bl = isConstant = var instanceof PsiEnumConstant || modifierList != null && modifierList.hasModifierProperty("static") && modifierList.hasModifierProperty("final");
                        if (!isConstant) {
                            this.myExpressions.add(new TextWithImportsImpl((PsiElement)reference));
                        }
                    }
                } else if (this.myVisibleLocals.contains(var.getName())) {
                    this.myVars.add(var.getName());
                } else if (!Comparing.equal((Object)PsiTreeUtil.getParentOfType((PsiElement)reference, PsiClass.class), (Object)PsiTreeUtil.getParentOfType((PsiElement)var, PsiClass.class))) {
                    this.myExpressions.add(new TextWithImportsImpl((PsiElement)reference));
                }
            }
            super.visitReferenceExpression(reference);
        }

        public void visitArrayAccessExpression(PsiArrayAccessExpression expression) {
            if (this.myCollectExpressions && !DebuggerUtils.hasSideEffectsOrReferencesMissingVars((PsiElement)expression, this.myVisibleLocals)) {
                this.myExpressions.add(new TextWithImportsImpl((PsiElement)expression));
            }
            super.visitArrayAccessExpression(expression);
        }

        public void visitParameter(PsiParameter parameter) {
            this.processVariable((PsiVariable)parameter);
            super.visitParameter(parameter);
        }

        public void visitLocalVariable(PsiLocalVariable variable) {
            this.processVariable((PsiVariable)variable);
            super.visitLocalVariable(variable);
        }

        private void processVariable(PsiVariable variable) {
            if (this.myLineRange.intersects(variable.getTextRange()) && this.myVisibleLocals.contains(variable.getName())) {
                this.myVars.add(variable.getName());
            }
        }

        public void visitClass(PsiClass aClass) {
        }
    }

    static class DummyMessageValueNode
    extends XNamedValue {
        private final String myMessage;
        private final Icon myIcon;

        public DummyMessageValueNode(String message, Icon icon) {
            super("");
            this.myMessage = message;
            this.myIcon = icon;
        }

        public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/debugger/engine/JavaStackFrame$DummyMessageValueNode", "computePresentation"));
            }
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/debugger/engine/JavaStackFrame$DummyMessageValueNode", "computePresentation"));
            }
            node.setPresentation(this.myIcon, new XValuePresentation(){

                @NotNull
                public String getSeparator() {
                    if ("" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JavaStackFrame$DummyMessageValueNode$1", "getSeparator"));
                    }
                    return "";
                }

                public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                    if (renderer == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/debugger/engine/JavaStackFrame$DummyMessageValueNode$1", "renderValue"));
                    }
                    renderer.renderValue(DummyMessageValueNode.this.myMessage);
                }
            }, false);
        }
    }
}

