/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class NewClassInstanceEvaluator
implements Evaluator {
    private final Evaluator myClassTypeEvaluator;
    private final JVMName myConstructorSignature;
    private final Evaluator[] myParamsEvaluators;

    public NewClassInstanceEvaluator(Evaluator classTypeEvaluator, JVMName constructorSignature, Evaluator[] argumentEvaluators) {
        this.myClassTypeEvaluator = classTypeEvaluator;
        this.myConstructorSignature = constructorSignature;
        this.myParamsEvaluators = argumentEvaluators;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        ObjectReference objRef;
        List arguments;
        DebugProcessImpl debugProcess = context.getDebugProcess();
        Object obj = this.myClassTypeEvaluator.evaluate(context);
        if (!(obj instanceof ClassType)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.evaluate.class.type", (Object[])new Object[0]));
        }
        ClassType classType = (ClassType)obj;
        Method method = DebuggerUtils.findMethod((ReferenceType)classType, (String)"<init>", (String)this.myConstructorSignature.getName(debugProcess));
        if (method == null) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.resolve.constructor", (Object[])new Object[]{this.myConstructorSignature.getDisplayName(debugProcess)}));
        }
        if (this.myParamsEvaluators != null) {
            arguments = new ArrayList(this.myParamsEvaluators.length);
            for (Evaluator evaluator : this.myParamsEvaluators) {
                arguments.add(evaluator.evaluate(context));
            }
        } else {
            arguments = Collections.emptyList();
        }
        try {
            objRef = debugProcess.newInstance(context, classType, method, arguments);
        }
        catch (EvaluateException e) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
        return objRef;
    }

    @Override
    public Modifier getModifier() {
        return null;
    }
}

