/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.FieldDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.util.IncorrectOperationException;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldDescriptorImpl
extends ValueDescriptorImpl
implements FieldDescriptor {
    public static final String OUTER_LOCAL_VAR_FIELD_PREFIX = "val$";
    private final Field myField;
    private final ObjectReference myObject;
    private Boolean myIsPrimitive;
    private final boolean myIsStatic;

    public FieldDescriptorImpl(Project project, ObjectReference objRef, @NotNull Field field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/debugger/ui/impl/watch/FieldDescriptorImpl", "<init>"));
        }
        super(project);
        this.myIsPrimitive = null;
        this.myObject = objRef;
        this.myField = field;
        this.myIsStatic = field.isStatic();
        this.setLvalue(!field.isFinal());
    }

    @Override
    public Field getField() {
        return this.myField;
    }

    @Override
    public ObjectReference getObject() {
        return this.myObject;
    }

    @Override
    public void setAncestor(NodeDescriptor oldDescriptor) {
        super.setAncestor(oldDescriptor);
        Boolean isPrimitive = ((FieldDescriptorImpl)oldDescriptor).myIsPrimitive;
        if (isPrimitive != null) {
            this.myIsPrimitive = isPrimitive;
        }
    }

    @Override
    public boolean isPrimitive() {
        if (this.myIsPrimitive == null) {
            Value value = this.getValue();
            this.myIsPrimitive = value != null ? Boolean.valueOf(super.isPrimitive()) : Boolean.valueOf(DebuggerUtils.isPrimitiveType((String)this.myField.typeName()));
        }
        return this.myIsPrimitive;
    }

    @Override
    public Value calcValue(EvaluationContextImpl evaluationContext) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            return this.myObject != null ? this.myObject.getValue(this.myField) : this.myField.declaringType().getValue(this.myField);
        }
        catch (ObjectCollectedException ignored) {
            throw EvaluateExceptionUtil.OBJECT_WAS_COLLECTED;
        }
    }

    public boolean isStatic() {
        return this.myIsStatic;
    }

    @Override
    public String getName() {
        return this.myField.name();
    }

    @Override
    public String calcValueName() {
        String res = super.calcValueName();
        if (Boolean.TRUE.equals(this.getUserData(SHOW_DECLARING_TYPE))) {
            return NodeRendererSettings.getInstance().getClassRenderer().renderTypeName(this.myField.declaringType().name()) + "." + res;
        }
        return res;
    }

    public boolean isOuterLocalVariableValue() {
        try {
            return DebuggerUtils.isSynthetic((TypeComponent)this.myField) && this.myField.name().startsWith(OUTER_LOCAL_VAR_FIELD_PREFIX);
        }
        catch (UnsupportedOperationException ignored) {
            return false;
        }
    }

    @Override
    @Nullable
    public String getDeclaredType() {
        return this.myField.typeName();
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext context) throws EvaluateException {
        String fieldName;
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory();
        if (this.isStatic()) {
            String typeName = this.myField.declaringType().name().replace('$', '.');
            typeName = DebuggerTreeNodeExpression.normalize(typeName, PositionUtil.getContextElement((StackFrameContext)context), context.getProject());
            fieldName = typeName + "." + this.getName();
        } else {
            fieldName = this.isOuterLocalVariableValue() ? StringUtil.trimStart((String)this.getName(), (String)OUTER_LOCAL_VAR_FIELD_PREFIX) : "this." + this.getName();
        }
        try {
            return elementFactory.createExpressionFromText(fieldName, null);
        }
        catch (IncorrectOperationException e) {
            throw new EvaluateException(DebuggerBundle.message((String)"error.invalid.field.name", (Object[])new Object[]{this.getName()}), (Throwable)e);
        }
    }
}

