/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render.configurables;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.ui.CompletionEditor;
import com.intellij.debugger.ui.DebuggerExpressionComboBox;
import com.intellij.debugger.ui.tree.render.ExpressionChildrenRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ClassChildrenExpressionConfigurable
implements UnnamedConfigurable,
Disposable {
    private final ExpressionChildrenRenderer myRenderer;
    private JPanel myPanel;
    private LabeledComponent<JPanel> myChildrenPanel;
    private LabeledComponent<JPanel> myExpandablePanel;
    private final CompletionEditor myChildrenEditor;
    private final CompletionEditor myExpandableEditor;

    public ClassChildrenExpressionConfigurable(@NotNull Project project, @NotNull ExpressionChildrenRenderer renderer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/tree/render/configurables/ClassChildrenExpressionConfigurable", "<init>"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/debugger/ui/tree/render/configurables/ClassChildrenExpressionConfigurable", "<init>"));
        }
        this.myRenderer = renderer;
        this.$$$setupUI$$$();
        PsiClass psiClass = DebuggerUtils.findClass((String)this.myRenderer.getClassName(), (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
        this.myChildrenEditor = new DebuggerExpressionComboBox(project, this, (PsiElement)psiClass, "ClassChildrenExpression");
        this.myExpandableEditor = new DebuggerExpressionComboBox(project, this, (PsiElement)psiClass, "ClassChildrenExpression");
        ((JPanel)this.myChildrenPanel.getComponent()).setLayout(new BorderLayout());
        ((JPanel)this.myChildrenPanel.getComponent()).add(this.myChildrenEditor);
        ((JPanel)this.myExpandablePanel.getComponent()).setLayout(new BorderLayout());
        ((JPanel)this.myExpandablePanel.getComponent()).add(this.myExpandableEditor);
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        return !this.myRenderer.getChildrenExpression().equals(this.myChildrenEditor.getText()) || !this.myRenderer.getChildrenExpandable().equals(this.myExpandableEditor.getText());
    }

    public void apply() throws ConfigurationException {
        this.myRenderer.setChildrenExpression(this.myChildrenEditor.getText());
        this.myRenderer.setChildrenExpandable(this.myExpandableEditor.getText());
    }

    public void reset() {
        this.myChildrenEditor.setText(this.myRenderer.getChildrenExpression());
        this.myExpandableEditor.setText(this.myRenderer.getChildrenExpandable());
    }

    public void dispose() {
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        LabeledComponent labeledComponent;
        LabeledComponent labeledComponent2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myChildrenPanel = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setText(ResourceBundle.getBundle("messages/DebuggerBundle").getString("label.node.descendands.expression"));
        labeledComponent2.setLabelInsets(new Insets(0, 0, 5, 0));
        labeledComponent2.setComponentClass("javax.swing.JPanel");
        jPanel.add((Component)labeledComponent2, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        this.myExpandablePanel = labeledComponent = new LabeledComponent();
        labeledComponent.setText(ResourceBundle.getBundle("messages/DebuggerBundle").getString("node.has.descendands.expression.optional"));
        labeledComponent.setLabelInsets(new Insets(0, 0, 5, 0));
        labeledComponent.setComponentClass("javax.swing.JPanel");
        jPanel.add((Component)labeledComponent, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

