/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DebugLogManager
extends ApplicationComponent.Adapter {
    private static final com.intellij.openapi.diagnostic.Logger LOG = com.intellij.openapi.diagnostic.Logger.getInstance(DebugLogManager.class);
    private static final String LOG_DEBUG_CATEGORIES = "log.debug.categories";

    public void initComponent() {
        List<String> categories = this.getSavedCategories();
        if (categories.isEmpty()) {
            this.saveCategories(DebugLogManager.getCurrentCategories());
        } else {
            this.applyCategories(categories);
        }
    }

    @NotNull
    public List<String> getSavedCategories() {
        String value = PropertiesComponent.getInstance().getValue(LOG_DEBUG_CATEGORIES);
        List<Object> list = value == null ? Collections.emptyList() : DebugLogManager.fromString(value);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/DebugLogManager", "getSavedCategories"));
        }
        return list;
    }

    public void applyCategories(@NotNull List<String> categories) {
        if (categories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "categories", "com/intellij/diagnostic/DebugLogManager", "applyCategories"));
        }
        for (String category : categories) {
            Logger logger = LogManager.getLogger((String)category);
            if (logger == null) continue;
            logger.setLevel(Level.DEBUG);
        }
        LOG.info("Set DEBUG for the following categories: " + categories);
    }

    public void saveCategories(@NotNull List<String> categories) {
        if (categories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "categories", "com/intellij/diagnostic/DebugLogManager", "saveCategories"));
        }
        PropertiesComponent.getInstance().setValue(LOG_DEBUG_CATEGORIES, categories.isEmpty() ? null : DebugLogManager.toString(categories), null);
    }

    @NotNull
    private static List<String> fromString(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diagnostic/DebugLogManager", "fromString"));
        }
        List<String> list = Arrays.asList(StringUtil.splitByLines((String)text, (boolean)true));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/DebugLogManager", "fromString"));
        }
        return list;
    }

    @NotNull
    private static String toString(@NotNull List<String> categories) {
        if (categories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "categories", "com/intellij/diagnostic/DebugLogManager", "toString"));
        }
        String string = StringUtil.join(categories, (String)"\n");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/DebugLogManager", "toString"));
        }
        return string;
    }

    @NotNull
    private static List<String> getCurrentCategories() {
        Enumeration currentLoggers = LogManager.getCurrentLoggers();
        List list = ContainerUtil.mapNotNull((Collection)ContainerUtil.toList((Enumeration)currentLoggers), (Function)new Function<Object, String>(){

            public String fun(Object o) {
                String category;
                if (o instanceof Logger && com.intellij.openapi.diagnostic.Logger.getInstance((String)(category = ((Logger)o).getName())).isDebugEnabled()) {
                    return category;
                }
                return null;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/DebugLogManager", "getCurrentCategories"));
        }
        return list;
    }
}

