/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.side;

import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.tools.holders.EditorHolder;
import com.intellij.diff.tools.holders.EditorHolderFactory;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.FocusTrackerSupport;
import com.intellij.diff.tools.util.SimpleDiffPanel;
import com.intellij.diff.tools.util.base.ListenerDiffViewerBase;
import com.intellij.diff.tools.util.side.ThreesideContentPanel;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Disposer;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ThreesideDiffViewer<T extends EditorHolder>
extends ListenerDiffViewerBase {
    @NotNull
    protected final SimpleDiffPanel myPanel;
    @NotNull
    protected final ThreesideContentPanel myContentPanel;
    @NotNull
    private final List<T> myHolders;
    @NotNull
    private final FocusTrackerSupport.ThreesideFocusTrackerSupport myFocusTrackerSupport;

    public ThreesideDiffViewer(@NotNull DiffContext context, @NotNull ContentDiffRequest request, @NotNull EditorHolderFactory<T> factory) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/side/ThreesideDiffViewer", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/side/ThreesideDiffViewer", "<init>"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/diff/tools/util/side/ThreesideDiffViewer", "<init>"));
        }
        super(context, request);
        this.myHolders = this.createEditorHolders(factory);
        List<JComponent> titlePanel = this.createTitles();
        this.myFocusTrackerSupport = new FocusTrackerSupport.ThreesideFocusTrackerSupport(this.myHolders);
        this.myContentPanel = new ThreesideContentPanel(this.myHolders, titlePanel);
        this.myPanel = new SimpleDiffPanel(this.myContentPanel, (DataProvider)this, context);
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.myPanel.setPersistentNotifications(DiffUtil.getCustomNotifications(this.myContext, (DiffRequest)this.myRequest));
    }

    @Override
    protected void onDispose() {
        this.destroyEditorHolders();
        super.onDispose();
    }

    @Override
    protected void processContextHints() {
        super.processContextHints();
        this.myFocusTrackerSupport.processContextHints((DiffRequest)this.myRequest, this.myContext);
    }

    @Override
    protected void updateContextHints() {
        super.updateContextHints();
        this.myFocusTrackerSupport.updateContextHints((DiffRequest)this.myRequest, this.myContext);
    }

    @NotNull
    protected List<T> createEditorHolders(@NotNull EditorHolderFactory<T> factory) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/diff/tools/util/side/ThreesideDiffViewer", "createEditorHolders"));
        }
        List contents = this.myRequest.getContents();
        ArrayList<T> holders = new ArrayList<T>(3);
        for (int i = 0; i < 3; ++i) {
            DiffContent content = (DiffContent)contents.get(i);
            holders.add(factory.create(content, this.myContext));
        }
        ArrayList<T> arrayList = holders;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideDiffViewer", "createEditorHolders"));
        }
        return arrayList;
    }

    private void destroyEditorHolders() {
        for (EditorHolder holder : this.myHolders) {
            Disposer.dispose((Disposable)holder);
        }
    }

    @NotNull
    protected List<JComponent> createTitles() {
        List<JComponent> list = DiffUtil.createSimpleTitles(this.myRequest);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideDiffViewer", "createTitles"));
        }
        return list;
    }

    @NotNull
    public JComponent getComponent() {
        SimpleDiffPanel simpleDiffPanel = this.myPanel;
        if (simpleDiffPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideDiffViewer", "getComponent"));
        }
        return simpleDiffPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (!this.myPanel.isGoodContent()) {
            return null;
        }
        return ((EditorHolder)this.getCurrentEditorHolder()).getPreferredFocusedComponent();
    }

    @NotNull
    public ThreeSide getCurrentSide() {
        ThreeSide threeSide = this.myFocusTrackerSupport.getCurrentSide();
        if (threeSide == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideDiffViewer", "getCurrentSide"));
        }
        return threeSide;
    }

    protected void setCurrentSide(@NotNull ThreeSide side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/side/ThreesideDiffViewer", "setCurrentSide"));
        }
        this.myFocusTrackerSupport.setCurrentSide(side);
    }

    @NotNull
    protected List<T> getEditorHolders() {
        List<T> list = this.myHolders;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideDiffViewer", "getEditorHolders"));
        }
        return list;
    }

    @NotNull
    protected T getCurrentEditorHolder() {
        EditorHolder editorHolder = (EditorHolder)this.getCurrentSide().select(this.getEditorHolders());
        if (editorHolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideDiffViewer", "getCurrentEditorHolder"));
        }
        return (T)editorHolder;
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return DiffUtil.getVirtualFile(this.myRequest, this.getCurrentSide());
        }
        if (DiffDataKeys.CURRENT_CONTENT.is(dataId)) {
            return this.getCurrentSide().select(this.myRequest.getContents());
        }
        return super.getData(dataId);
    }

    @Override
    @Nullable
    protected OpenFileDescriptor getOpenFileDescriptor() {
        return ((DiffContent)this.getCurrentSide().select(this.getRequest().getContents())).getOpenFileDescriptor();
    }

    public static <T extends EditorHolder> boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request, @NotNull EditorHolderFactory<T> factory) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/side/ThreesideDiffViewer", "canShowRequest"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/side/ThreesideDiffViewer", "canShowRequest"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/diff/tools/util/side/ThreesideDiffViewer", "canShowRequest"));
        }
        if (!(request instanceof ContentDiffRequest)) {
            return false;
        }
        List contents = ((ContentDiffRequest)request).getContents();
        if (contents.size() != 3) {
            return false;
        }
        boolean canShow = true;
        boolean wantShow = false;
        for (DiffContent content : contents) {
            canShow &= factory.canShowContent(content, context);
            wantShow |= factory.wantShowContent(content, context);
        }
        return canShow && wantShow;
    }

    protected class ShowPartialDiffAction
    extends DumbAwareAction {
        @NotNull
        private final ThreeSide mySide1;
        @NotNull
        private final ThreeSide mySide2;

        public ShowPartialDiffAction(@NotNull ThreeSide side1, @NotNull ThreeSide side2, @Nullable String text, @NotNull String description, Icon icon) {
            if (side1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side1", "com/intellij/diff/tools/util/side/ThreesideDiffViewer$ShowPartialDiffAction", "<init>"));
            }
            if (side2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side2", "com/intellij/diff/tools/util/side/ThreesideDiffViewer$ShowPartialDiffAction", "<init>"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/tools/util/side/ThreesideDiffViewer$ShowPartialDiffAction", "<init>"));
            }
            if (icon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/diff/tools/util/side/ThreesideDiffViewer$ShowPartialDiffAction", "<init>"));
            }
            super(text, description, icon);
            this.mySide1 = side1;
            this.mySide2 = side2;
        }

        public void actionPerformed(AnActionEvent e) {
            List contents = ThreesideDiffViewer.this.myRequest.getContents();
            List titles = ThreesideDiffViewer.this.myRequest.getContentTitles();
            SimpleDiffRequest request = new SimpleDiffRequest(ThreesideDiffViewer.this.myRequest.getTitle(), (DiffContent)this.mySide1.select(contents), (DiffContent)this.mySide2.select(contents), (String)this.mySide1.select(titles), (String)this.mySide2.select(titles));
            DiffManager.getInstance().showDiff(ThreesideDiffViewer.this.myProject, (DiffRequest)request, new DiffDialogHints(null, (Component)ThreesideDiffViewer.this.myPanel));
        }
    }

    protected class ShowLeftRightPartialDiffAction
    extends ShowPartialDiffAction {
        public ShowLeftRightPartialDiffAction() {
            super(ThreeSide.LEFT, ThreeSide.RIGHT, DiffBundle.message((String)"merge.partial.diff.action.name", (Object[])new Object[0]), null, AllIcons.Diff.BranchDiff);
        }
    }

    protected class ShowBaseRightPartialDiffAction
    extends ShowPartialDiffAction {
        public ShowBaseRightPartialDiffAction() {
            super(ThreeSide.BASE, ThreeSide.RIGHT, DiffBundle.message((String)"merge.partial.diff.action.name.1.2", (Object[])new Object[0]), null, AllIcons.Diff.RightDiff);
        }
    }

    protected class ShowLeftBasePartialDiffAction
    extends ShowPartialDiffAction {
        public ShowLeftBasePartialDiffAction() {
            super(ThreeSide.LEFT, ThreeSide.BASE, DiffBundle.message((String)"merge.partial.diff.action.name.0.1", (Object[])new Object[0]), null, AllIcons.Diff.LeftDiff);
        }
    }
}

