/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DvcsRememberedInputs {
    private State myState = new State();

    @NotNull
    public State getState() {
        State state = this.myState;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsRememberedInputs", "getState"));
        }
        return state;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    public void addUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/dvcs/DvcsRememberedInputs", "addUrl"));
        }
        this.addUrl(url, "");
    }

    public void addUrl(@NotNull String url, @NotNull String userName) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/dvcs/DvcsRememberedInputs", "addUrl"));
        }
        if (userName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userName", "com/intellij/dvcs/DvcsRememberedInputs", "addUrl"));
        }
        for (UrlAndUserName visitedUrl : this.myState.visitedUrls) {
            if (!visitedUrl.url.equalsIgnoreCase(url)) continue;
            if (!userName.isEmpty()) {
                visitedUrl.userName = userName;
            }
            return;
        }
        UrlAndUserName urlAndUserName = new UrlAndUserName();
        urlAndUserName.url = url;
        urlAndUserName.userName = userName;
        this.myState.visitedUrls.add(urlAndUserName);
    }

    @Nullable
    public String getUserNameForUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/dvcs/DvcsRememberedInputs", "getUserNameForUrl"));
        }
        for (UrlAndUserName urlAndUserName : this.myState.visitedUrls) {
            if (!urlAndUserName.url.equalsIgnoreCase(url)) continue;
            return urlAndUserName.userName;
        }
        return null;
    }

    @NotNull
    public List<String> getVisitedUrls() {
        ArrayList<String> urls = new ArrayList<String>(this.myState.visitedUrls.size());
        for (UrlAndUserName urlAndUserName : this.myState.visitedUrls) {
            urls.add(urlAndUserName.url);
        }
        ArrayList<String> arrayList = urls;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsRememberedInputs", "getVisitedUrls"));
        }
        return arrayList;
    }

    public String getCloneParentDir() {
        return this.myState.cloneParentDir;
    }

    public void setCloneParentDir(String cloneParentDir) {
        this.myState.cloneParentDir = cloneParentDir;
    }

    public static class UrlAndUserName {
        public String url;
        public String userName;
    }

    public static class State {
        public List<UrlAndUserName> visitedUrls = new ArrayList<UrlAndUserName>();
        public String cloneParentDir = "";
    }
}

