/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs;

import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.RepoStateException;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.intellij.images.editor.ImageFileEditor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DvcsUtil {
    private static final Logger LOG = Logger.getInstance(DvcsUtil.class);
    private static final Logger LOGGER = Logger.getInstance(DvcsUtil.class);
    private static final int IO_RETRIES = 3;
    private static final int SHORT_HASH_LENGTH = 8;
    private static final int LONG_HASH_LENGTH = 40;
    public static final Comparator<Repository> REPOSITORY_COMPARATOR = new Comparator<Repository>(){

        @Override
        public int compare(Repository o1, Repository o2) {
            return o1.getPresentableUrl().compareTo(o2.getPresentableUrl());
        }
    };

    @Deprecated
    @NotNull
    public static String getShortRepositoryName(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/DvcsUtil", "getShortRepositoryName"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/dvcs/DvcsUtil", "getShortRepositoryName"));
        }
        String string = VcsImplUtil.getShortVcsRootName(project, root);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "getShortRepositoryName"));
        }
        return string;
    }

    @NotNull
    public static String getShortRepositoryName(@NotNull Repository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/dvcs/DvcsUtil", "getShortRepositoryName"));
        }
        String string = DvcsUtil.getShortRepositoryName(repository.getProject(), repository.getRoot());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "getShortRepositoryName"));
        }
        return string;
    }

    @NotNull
    public static String getShortNames(@NotNull Collection<? extends Repository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "com/intellij/dvcs/DvcsUtil", "getShortNames"));
        }
        String string = StringUtil.join(repositories, (Function)new Function<Repository, String>(){

            public String fun(Repository repository) {
                return DvcsUtil.getShortRepositoryName(repository);
            }
        }, (String)", ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "getShortNames"));
        }
        return string;
    }

    public static boolean anyRepositoryIsFresh(Collection<? extends Repository> repositories) {
        for (Repository repository : repositories) {
            if (!repository.isFresh()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String joinMessagesOrNull(@NotNull Collection<String> messages) {
        if (messages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messages", "com/intellij/dvcs/DvcsUtil", "joinMessagesOrNull"));
        }
        String joined = StringUtil.join(messages, (String)"\n");
        return StringUtil.isEmptyOrSpaces((String)joined) ? null : joined;
    }

    @Nullable
    public static VirtualFile getSelectedFile(@NotNull Project project) {
        Editor editor;
        FileEditorManager manager;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/DvcsUtil", "getSelectedFile"));
        }
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
        FileEditor fileEditor = StatusBarUtil.getCurrentFileEditor(project, statusBar);
        VirtualFile result2 = null;
        if (fileEditor != null) {
            if (fileEditor instanceof TextEditor) {
                Document document = ((TextEditor)fileEditor).getEditor().getDocument();
                result2 = FileDocumentManager.getInstance().getFile(document);
            } else if (fileEditor instanceof ImageFileEditor) {
                result2 = ((ImageFileEditor)fileEditor).getImageEditor().getFile();
            }
        }
        if (result2 == null && (manager = FileEditorManager.getInstance((Project)project)) != null && (editor = manager.getSelectedTextEditor()) != null) {
            result2 = FileDocumentManager.getInstance().getFile(editor.getDocument());
        }
        return result2;
    }

    @NotNull
    public static String getShortHash(@NotNull String hash) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/dvcs/DvcsUtil", "getShortHash"));
        }
        if (hash.length() < 8) {
            LOG.debug("Unexpectedly short hash: [" + hash + "]");
        }
        if (hash.length() > 40) {
            LOG.debug("Unexpectedly long hash: [" + hash + "]");
        }
        String string = hash.substring(0, Math.min(8, hash.length()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "getShortHash"));
        }
        return string;
    }

    @NotNull
    public static String getDateString(@NotNull TimedVcsCommit commit) {
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/dvcs/DvcsUtil", "getDateString"));
        }
        String string = DateFormatUtil.formatPrettyDateTime((long)commit.getTimestamp()) + " ";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "getDateString"));
        }
        return string;
    }

    @NotNull
    public static AccessToken workingTreeChangeStarted(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/DvcsUtil", "workingTreeChangeStarted"));
        }
        ((BatchFileChangeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(BatchFileChangeListener.TOPIC)).batchChangeStarted(project);
        AccessToken accessToken = HeavyProcessLatch.INSTANCE.processStarted("Changing DVCS working tree");
        if (accessToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "workingTreeChangeStarted"));
        }
        return accessToken;
    }

    public static void workingTreeChangeFinished(@NotNull Project project, @NotNull AccessToken token) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/DvcsUtil", "workingTreeChangeFinished"));
        }
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/dvcs/DvcsUtil", "workingTreeChangeFinished"));
        }
        token.finish();
        ((BatchFileChangeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(BatchFileChangeListener.TOPIC)).batchChangeCompleted(project);
    }

    public static void assertFileExists(File file, String message) throws IllegalStateException {
        if (!file.exists()) {
            throw new IllegalStateException(message);
        }
    }

    @NotNull
    public static String tryLoadFile(final @NotNull File file) throws RepoStateException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dvcs/DvcsUtil", "tryLoadFile"));
        }
        String string = DvcsUtil.tryOrThrow(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)file)).trim();
            }
        }, file);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "tryLoadFile"));
        }
        return string;
    }

    @Nullable
    @Contract(value="_ , !null -> !null")
    public static String tryLoadFileOrReturn(@NotNull File file, @Nullable String defaultValue) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dvcs/DvcsUtil", "tryLoadFileOrReturn"));
        }
        try {
            return DvcsUtil.tryLoadFile(file);
        }
        catch (RepoStateException e) {
            LOG.error((Throwable)e);
            return defaultValue;
        }
    }

    private static <T> T tryOrThrow(Callable<T> actionToTry, File fileToLoad) throws RepoStateException {
        IOException cause = null;
        for (int i = 0; i < 3; ++i) {
            try {
                return actionToTry.call();
            }
            catch (IOException e) {
                LOG.info("IOException while loading " + fileToLoad, (Throwable)e);
                cause = e;
                continue;
            }
            catch (Exception e) {
                throw new RepoStateException("Couldn't load file " + fileToLoad, e);
            }
        }
        throw new RepoStateException("Couldn't load file " + fileToLoad, cause);
    }

    public static void visitVcsDirVfs(@NotNull VirtualFile vcsDir, @NotNull Collection<String> subDirs) {
        if (vcsDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsDir", "com/intellij/dvcs/DvcsUtil", "visitVcsDirVfs"));
        }
        if (subDirs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subDirs", "com/intellij/dvcs/DvcsUtil", "visitVcsDirVfs"));
        }
        vcsDir.getChildren();
        for (String subdir : subDirs) {
            VirtualFile dir = vcsDir.findFileByRelativePath(subdir);
            DvcsUtil.ensureAllChildrenInVfs(dir);
        }
    }

    public static void ensureAllChildrenInVfs(@Nullable VirtualFile dir) {
        if (dir != null) {
            VfsUtilCore.processFilesRecursively((VirtualFile)dir, (Processor)Processor.TRUE);
        }
    }

    public static void addMappingIfSubRoot(@NotNull Project project, @NotNull String newRepositoryPath, @NotNull String vcsName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/DvcsUtil", "addMappingIfSubRoot"));
        }
        if (newRepositoryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRepositoryPath", "com/intellij/dvcs/DvcsUtil", "addMappingIfSubRoot"));
        }
        if (vcsName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsName", "com/intellij/dvcs/DvcsUtil", "addMappingIfSubRoot"));
        }
        if (project.getBasePath() != null && FileUtil.isAncestor((String)project.getBasePath(), (String)newRepositoryPath, (boolean)true)) {
            ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance((Project)project);
            manager.setDirectoryMappings(VcsUtil.addMapping((List)manager.getDirectoryMappings(), (String)newRepositoryPath, (String)vcsName));
        }
    }

    @Nullable
    public static <T extends Repository> T guessRepositoryForFile(@NotNull Project project, @NotNull RepositoryManager<T> manager, @Nullable AbstractVcs vcs, @Nullable VirtualFile file, @Nullable String defaultRootPathValue) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/DvcsUtil", "guessRepositoryForFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/dvcs/DvcsUtil", "guessRepositoryForFile"));
        }
        Repository repository = manager.getRepositoryForRoot(DvcsUtil.guessVcsRoot(project, file));
        return (T)(repository != null ? repository : manager.getRepositoryForRoot(DvcsUtil.guessRootForVcs(project, vcs, defaultRootPathValue)));
    }

    @Nullable
    public static <T extends Repository> T guessCurrentRepositoryQuick(@NotNull Project project, @NotNull AbstractRepositoryManager<T> manager, @Nullable String defaultRootPathValue) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/DvcsUtil", "guessCurrentRepositoryQuick"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/dvcs/DvcsUtil", "guessCurrentRepositoryQuick"));
        }
        T repository = manager.getRepositoryForRootQuick(DvcsUtil.guessVcsRoot(project, DvcsUtil.getSelectedFile(project)));
        return repository != null ? repository : manager.getRepositoryForRootQuick(DvcsUtil.guessRootForVcs(project, manager.getVcs(), defaultRootPathValue));
    }

    @Nullable
    private static VirtualFile guessRootForVcs(@NotNull Project project, @Nullable AbstractVcs vcs, @Nullable String defaultRootPathValue) {
        VirtualFile recentRoot;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/DvcsUtil", "guessRootForVcs"));
        }
        if (project.isDisposed()) {
            return null;
        }
        LOG.debug("Guessing vcs root...");
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        if (vcs == null) {
            LOG.debug("Vcs not found.");
            return null;
        }
        String vcsName = vcs.getDisplayName();
        VirtualFile[] vcsRoots = vcsManager.getRootsUnderVcs(vcs);
        if (vcsRoots.length == 0) {
            LOG.debug("No " + vcsName + " roots in the project.");
            return null;
        }
        if (vcsRoots.length == 1) {
            VirtualFile onlyRoot = vcsRoots[0];
            LOG.debug("Only one " + vcsName + " root in the project, returning: " + onlyRoot);
            return onlyRoot;
        }
        if (defaultRootPathValue != null && (recentRoot = VcsUtil.getVirtualFile((String)defaultRootPathValue)) != null) {
            LOG.debug("Returning the recent root: " + recentRoot);
            return recentRoot;
        }
        VirtualFile projectBaseDir = project.getBaseDir();
        if (projectBaseDir == null) {
            VirtualFile firstRoot = vcsRoots[0];
            LOG.debug("Project base dir is null, returning the first root: " + firstRoot);
            return firstRoot;
        }
        for (VirtualFile root : vcsRoots) {
            if (!root.equals(projectBaseDir) && !VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)projectBaseDir, (boolean)true)) continue;
            LOG.debug("The best candidate: " + root);
            return root;
        }
        VirtualFile rootCandidate = vcsRoots[0];
        LOG.debug("Returning the best candidate: " + rootCandidate);
        return rootCandidate;
    }

    public static <T extends Repository> List<T> sortRepositories(@NotNull Collection<T> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "com/intellij/dvcs/DvcsUtil", "sortRepositories"));
        }
        List validRepositories = ContainerUtil.filter(repositories, (Condition)new Condition<T>(){

            public boolean value(T t) {
                return t.getRoot().isValid();
            }
        });
        Collections.sort(validRepositories, REPOSITORY_COMPARATOR);
        return validRepositories;
    }

    @Nullable
    private static VirtualFile getVcsRootForLibraryFile(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/DvcsUtil", "getVcsRootForLibraryFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dvcs/DvcsUtil", "getVcsRootForLibraryFile"));
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        VirtualFile root = vcsManager.getVcsRootFor(VfsUtilCore.getVirtualFileForJar((VirtualFile)file));
        if (root != null) {
            LOGGER.debug("Found root for zip/jar file: " + root);
            return root;
        }
        List entries = ProjectRootManager.getInstance((Project)project).getFileIndex().getOrderEntriesForFile(file);
        HashSet<VirtualFile> libraryRoots = new HashSet<VirtualFile>();
        for (OrderEntry entry : entries) {
            VirtualFile moduleRoot;
            if (!(entry instanceof LibraryOrderEntry) && !(entry instanceof JdkOrderEntry) || (moduleRoot = vcsManager.getVcsRootFor(entry.getOwnerModule().getModuleFile())) == null) continue;
            libraryRoots.add(moduleRoot);
        }
        if (libraryRoots.size() == 0) {
            LOGGER.debug("No library roots");
            return null;
        }
        Iterator libIterator = libraryRoots.iterator();
        VirtualFile topLibraryRoot = (VirtualFile)libIterator.next();
        while (libIterator.hasNext()) {
            VirtualFile libRoot = (VirtualFile)libIterator.next();
            if (!VfsUtilCore.isAncestor((VirtualFile)libRoot, (VirtualFile)topLibraryRoot, (boolean)true)) continue;
            topLibraryRoot = libRoot;
        }
        LOGGER.debug("Several library roots, returning " + topLibraryRoot);
        return topLibraryRoot;
    }

    @Nullable
    private static VirtualFile guessVcsRoot(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/DvcsUtil", "guessVcsRoot"));
        }
        VirtualFile root = null;
        if (file != null && (root = ProjectLevelVcsManager.getInstance((Project)project).getVcsRootFor(file)) == null) {
            LOGGER.debug("Cannot get root by file. Trying with get by library: " + file);
            root = DvcsUtil.getVcsRootForLibraryFile(project, file);
        }
        return root;
    }

    @NotNull
    public static <R extends Repository> Map<R, List<VcsFullCommitDetails>> groupCommitsByRoots(@NotNull RepositoryManager<R> repoManager, @NotNull List<? extends VcsFullCommitDetails> commits) {
        if (repoManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repoManager", "com/intellij/dvcs/DvcsUtil", "groupCommitsByRoots"));
        }
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/dvcs/DvcsUtil", "groupCommitsByRoots"));
        }
        HashMap groupedCommits = ContainerUtil.newHashMap();
        for (VcsFullCommitDetails vcsFullCommitDetails : commits) {
            Repository repository = repoManager.getRepositoryForRoot(vcsFullCommitDetails.getRoot());
            if (repository == null) {
                LOGGER.info("No repository found for commit " + vcsFullCommitDetails);
                continue;
            }
            List commitsInRoot = (List)groupedCommits.get(repository);
            if (commitsInRoot == null) {
                commitsInRoot = ContainerUtil.newArrayList();
                groupedCommits.put(repository, commitsInRoot);
            }
            commitsInRoot.add(vcsFullCommitDetails);
        }
        HashMap hashMap = groupedCommits;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "groupCommitsByRoots"));
        }
        return hashMap;
    }

    @Nullable
    public static PushSupport getPushSupport(final @NotNull AbstractVcs vcs) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/dvcs/DvcsUtil", "getPushSupport"));
        }
        return (PushSupport)ContainerUtil.find((Object[])Extensions.getExtensions((ExtensionPointName)PushSupport.PUSH_SUPPORT_EP, (AreaInstance)vcs.getProject()), (Condition)new Condition<PushSupport>(){

            public boolean value(PushSupport support) {
                return support.getVcs().equals((Object)vcs);
            }
        });
    }

    public static class Updater
    implements Consumer<Object> {
        private final Repository myRepository;

        public Updater(Repository repository) {
            this.myRepository = repository;
        }

        public void consume(Object dummy) {
            if (!Disposer.isDisposed((Disposable)this.myRepository)) {
                this.myRepository.update();
            }
        }
    }
}

