/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.branch;

import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsTaskHandler;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DvcsTaskHandler<R extends Repository>
extends VcsTaskHandler {
    @NotNull
    private final AbstractRepositoryManager<R> myRepositoryManager;
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myBranchType;

    protected DvcsTaskHandler(@NotNull AbstractRepositoryManager<R> repositoryManager, @NotNull Project project, @NotNull String branchType) {
        if (repositoryManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryManager", "com/intellij/dvcs/branch/DvcsTaskHandler", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/branch/DvcsTaskHandler", "<init>"));
        }
        if (branchType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchType", "com/intellij/dvcs/branch/DvcsTaskHandler", "<init>"));
        }
        this.myRepositoryManager = repositoryManager;
        this.myProject = project;
        this.myBranchType = branchType;
    }

    public boolean isEnabled() {
        return !this.myRepositoryManager.getRepositories().isEmpty();
    }

    public VcsTaskHandler.TaskInfo startNewTask(final @NotNull String taskName) {
        if (taskName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskName", "com/intellij/dvcs/branch/DvcsTaskHandler", "startNewTask"));
        }
        List<R> repositories = this.myRepositoryManager.getRepositories();
        List problems = ContainerUtil.filter(repositories, (Condition)new Condition<R>(){

            public boolean value(R repository) {
                return DvcsTaskHandler.this.hasBranch(repository, taskName);
            }
        });
        ArrayList<R> map = new ArrayList<R>();
        if (!problems.isEmpty() && (ApplicationManager.getApplication().isUnitTestMode() || Messages.showDialog((Project)this.myProject, (String)("<html>The following repositories already have specified " + this.myBranchType + "<b>" + taskName + "</b>:<br>" + StringUtil.join((Iterable)problems, (String)"<br>") + ".<br>" + "Do you want to checkout existing " + this.myBranchType + "?"), (String)(StringUtil.capitalize((String)this.myBranchType) + " Already Exists"), (String[])new String[]{Messages.YES_BUTTON, Messages.NO_BUTTON}, (int)0, (Icon)Messages.getWarningIcon(), (DialogWrapper.DoNotAskOption)new DialogWrapper.PropertyDoNotAskOption("git.checkout.existing.branch")) == 0)) {
            this.checkout(taskName, problems, null);
            map.addAll(problems);
        }
        repositories.removeAll(problems);
        if (!repositories.isEmpty()) {
            this.checkoutAsNewBranch(taskName, repositories);
        }
        map.addAll(repositories);
        return new VcsTaskHandler.TaskInfo(taskName, (Collection)ContainerUtil.map(map, (Function)new Function<R, String>(){

            public String fun(R r) {
                return r.getPresentableUrl();
            }
        }));
    }

    public void switchToTask(@NotNull VcsTaskHandler.TaskInfo taskInfo, @Nullable Runnable invokeAfter) {
        if (taskInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskInfo", "com/intellij/dvcs/branch/DvcsTaskHandler", "switchToTask"));
        }
        final String branchName = taskInfo.getName();
        List<R> repositories = this.getRepositories(taskInfo.getRepositories());
        List notFound = ContainerUtil.filter(repositories, (Condition)new Condition<R>(){

            public boolean value(R repository) {
                return !DvcsTaskHandler.this.hasBranch(repository, branchName);
            }
        });
        if (!notFound.isEmpty()) {
            this.checkoutAsNewBranch(branchName, notFound);
        }
        repositories.removeAll(notFound);
        if (!repositories.isEmpty()) {
            this.checkout(branchName, repositories, invokeAfter);
        }
    }

    public void closeTask(final @NotNull VcsTaskHandler.TaskInfo taskInfo, @NotNull VcsTaskHandler.TaskInfo original) {
        if (taskInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskInfo", "com/intellij/dvcs/branch/DvcsTaskHandler", "closeTask"));
        }
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/dvcs/branch/DvcsTaskHandler", "closeTask"));
        }
        this.checkout(original.getName(), this.getRepositories(original.getRepositories()), new Runnable(){

            @Override
            public void run() {
                DvcsTaskHandler.this.mergeAndClose(taskInfo.getName(), DvcsTaskHandler.this.getRepositories(taskInfo.getRepositories()));
            }
        });
    }

    public boolean isSyncEnabled() {
        return this.myRepositoryManager.isSyncEnabled();
    }

    public VcsTaskHandler.TaskInfo[] getCurrentTasks() {
        List<R> repositories = this.myRepositoryManager.getRepositories();
        FactoryMap<String, VcsTaskHandler.TaskInfo> tasks = new FactoryMap<String, VcsTaskHandler.TaskInfo>(){

            @Nullable
            protected VcsTaskHandler.TaskInfo create(String key) {
                return new VcsTaskHandler.TaskInfo(key, new ArrayList());
            }
        };
        for (Repository repository : repositories) {
            String branch = this.getActiveBranch(repository);
            if (branch == null) continue;
            ((VcsTaskHandler.TaskInfo)tasks.get((Object)branch)).getRepositories().add(repository.getPresentableUrl());
        }
        if (tasks.size() == 0) {
            return new VcsTaskHandler.TaskInfo[0];
        }
        if (this.isSyncEnabled()) {
            return new VcsTaskHandler.TaskInfo[]{(VcsTaskHandler.TaskInfo)tasks.values().iterator().next()};
        }
        return tasks.values().toArray(new VcsTaskHandler.TaskInfo[tasks.values().size()]);
    }

    public VcsTaskHandler.TaskInfo[] getAllExistingTasks() {
        List<R> repositories = this.myRepositoryManager.getRepositories();
        MultiMap tasks = new MultiMap();
        for (Repository repository : repositories) {
            for (String branch : this.getAllBranches(repository)) {
                tasks.putValue((Object)branch, (Object)repository.getPresentableUrl());
            }
        }
        return (VcsTaskHandler.TaskInfo[])ContainerUtil.map2Array((Collection)tasks.entrySet(), VcsTaskHandler.TaskInfo.class, (Function)new Function<Map.Entry<String, Collection<String>>, VcsTaskHandler.TaskInfo>(){

            public VcsTaskHandler.TaskInfo fun(Map.Entry<String, Collection<String>> entry) {
                return new VcsTaskHandler.TaskInfo(entry.getKey(), entry.getValue());
            }
        });
    }

    @NotNull
    private List<R> getRepositories(@NotNull Collection<String> urls) {
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "com/intellij/dvcs/branch/DvcsTaskHandler", "getRepositories"));
        }
        final List<R> repositories = this.myRepositoryManager.getRepositories();
        List list = ContainerUtil.mapNotNull(urls, (Function)new NullableFunction<String, R>(){

            @Nullable
            public R fun(final String s) {
                return (Repository)ContainerUtil.find((Iterable)repositories, (Condition)new Condition<R>(){

                    public boolean value(R repository) {
                        return s.equals(repository.getPresentableUrl());
                    }
                });
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/branch/DvcsTaskHandler", "getRepositories"));
        }
        return list;
    }

    protected abstract void checkout(@NotNull String var1, @NotNull List<R> var2, @Nullable Runnable var3);

    protected abstract void checkoutAsNewBranch(@NotNull String var1, @NotNull List<R> var2);

    @Nullable
    protected abstract String getActiveBranch(R var1);

    @NotNull
    protected abstract Iterable<String> getAllBranches(@NotNull R var1);

    protected abstract void mergeAndClose(@NotNull String var1, @NotNull List<R> var2);

    protected abstract boolean hasBranch(@NotNull R var1, @NotNull String var2);
}

