/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.MethodBrowser;
import com.intellij.execution.testDiscovery.TestDiscoveryConfiguration;
import com.intellij.execution.ui.ClassBrowser;
import com.intellij.execution.ui.CommonJavaParametersPanel;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.ide.util.ClassFilter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldWithBrowseButton;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;

public class TestDiscoveryConfigurable<T extends TestDiscoveryConfiguration>
extends SettingsEditor<T>
implements PanelWithAnchor {
    private final ConfigurationModuleSelector myModuleSelector;
    private JPanel myWholePanel = new JPanel(new BorderLayout());
    private LabeledComponent<ModulesComboBox> myModule = new LabeledComponent();
    private CommonJavaParametersPanel myCommonJavaParameters = new CommonJavaParametersPanel();
    private JrePathEditor myJrePathEditor;
    private LabeledComponent<EditorTextFieldWithBrowseButton> myClass = new LabeledComponent();
    private LabeledComponent<EditorTextFieldWithBrowseButton> myMethod = new LabeledComponent();
    private ComboBox myChangeLists = new ComboBox();
    private JRadioButton myPositionRb = new JRadioButton("Tests for method:");
    private JRadioButton myChangesRb = new JRadioButton("Tests for change list:");
    private JComponent anchor;

    public TestDiscoveryConfigurable(final Project project) {
        this.myModule.setText(ExecutionBundle.message((String)"application.configuration.use.classpath.and.jdk.of.module.label", (Object[])new Object[0]));
        this.myModule.setLabelLocation("West");
        this.myModule.setComponent((JComponent)((Object)new ModulesComboBox()));
        this.myModuleSelector = new ConfigurationModuleSelector(project, this.getModulesComponent());
        this.myCommonJavaParameters.setModuleContext(this.myModuleSelector.getModule());
        this.myCommonJavaParameters.setHasModuleMacro();
        ((ModulesComboBox)((Object)this.myModule.getComponent())).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestDiscoveryConfigurable.this.myCommonJavaParameters.setModuleContext(TestDiscoveryConfigurable.this.myModuleSelector.getModule());
            }
        });
        JPanel panelWithSettings = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        panelWithSettings.add((Component)this.myPositionRb, gc);
        this.myClass.setText("Class:");
        ClassBrowser classBrowser = new ClassBrowser(project, "Choose Class"){

            @Override
            protected ClassFilter.ClassFilterWithScope getFilter() throws ClassBrowser.NoFilterException {
                return new ClassFilter.ClassFilterWithScope(){

                    public GlobalSearchScope getScope() {
                        return GlobalSearchScope.allScope((Project)project);
                    }

                    public boolean isAccepted(PsiClass aClass) {
                        return true;
                    }
                };
            }

            @Override
            protected PsiClass findClass(String className) {
                return JavaPsiFacade.getInstance((Project)project).findClass(className, GlobalSearchScope.allScope((Project)project));
            }
        };
        EditorTextFieldWithBrowseButton classComponent = new EditorTextFieldWithBrowseButton(project, true);
        this.myClass.setComponent((JComponent)((Object)classComponent));
        classBrowser.setField(classComponent);
        panelWithSettings.add((Component)this.myClass, gc);
        this.myMethod.setText("Method:");
        EditorTextFieldWithBrowseButton textFieldWithBrowseButton = new EditorTextFieldWithBrowseButton(project, true, JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE, (FileType)PlainTextLanguage.INSTANCE.getAssociatedFileType());
        this.myMethod.setComponent((JComponent)((Object)textFieldWithBrowseButton));
        MethodBrowser methodBrowser = new MethodBrowser(project){

            @Override
            protected Condition<PsiMethod> getFilter(final PsiClass testClass) {
                return new Condition<PsiMethod>(){

                    public boolean value(PsiMethod method) {
                        return method.getContainingClass() == testClass;
                    }
                };
            }

            @Override
            protected String getClassName() {
                return ((EditorTextFieldWithBrowseButton)((Object)TestDiscoveryConfigurable.this.myClass.getComponent())).getText().trim();
            }

            @Override
            protected ConfigurationModuleSelector getModuleSelector() {
                return TestDiscoveryConfigurable.this.myModuleSelector;
            }
        };
        methodBrowser.setField(textFieldWithBrowseButton);
        methodBrowser.installCompletion((EditorTextField)((Object)textFieldWithBrowseButton.getChildComponent()));
        panelWithSettings.add((Component)this.myMethod, gc);
        panelWithSettings.add((Component)this.myChangesRb, gc);
        panelWithSettings.add((Component)this.myChangeLists, gc);
        ButtonGroup gr = new ButtonGroup();
        gr.add(this.myPositionRb);
        gr.add(this.myChangesRb);
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestDiscoveryConfigurable.this.updateComponents();
            }
        };
        this.myPositionRb.addActionListener(l);
        this.myChangesRb.addActionListener(l);
        List changeLists = ChangeListManager.getInstance((Project)project).getChangeLists();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement("All");
        for (LocalChangeList changeList : changeLists) {
            model.addElement(changeList.getName());
        }
        this.myChangeLists.setModel(model);
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        if (changeListManager.getAffectedFiles().isEmpty()) {
            this.myChangesRb.setEnabled(false);
        }
        this.myWholePanel.add((Component)panelWithSettings, "North");
        this.myWholePanel.add((Component)this.myCommonJavaParameters, "Center");
        JPanel classpathPanel = new JPanel(new BorderLayout());
        this.myWholePanel.add((Component)classpathPanel, "South");
        classpathPanel.add((Component)this.myModule, "North");
        this.myJrePathEditor = new JrePathEditor(DefaultJreSelector.fromModuleDependencies(this.getModulesComponent(), false));
        classpathPanel.add((Component)this.myJrePathEditor, "Center");
        UIUtil.setEnabled(this.myCommonJavaParameters.getProgramParametersComponent(), (boolean)false, (boolean)true);
        this.setAnchor((JComponent)this.myModule.getLabel());
        this.myJrePathEditor.setAnchor((JComponent)this.myModule.getLabel());
        this.myCommonJavaParameters.setAnchor((JComponent)this.myModule.getLabel());
    }

    private void updateComponents() {
        this.myClass.setEnabled(this.myPositionRb.isSelected());
        this.myMethod.setEnabled(this.myPositionRb.isSelected());
        this.myChangeLists.setEnabled(this.myChangesRb.isSelected());
    }

    public void applyEditorTo(TestDiscoveryConfiguration configuration) {
        this.applyHelpersTo(configuration);
        configuration.setAlternativeJrePath(this.myJrePathEditor.getJrePathOrName());
        configuration.setAlternativeJrePathEnabled(this.myJrePathEditor.isAlternativeJreSelected());
        configuration.setPosition(this.myPositionRb.isSelected() ? Pair.create((Object)((EditorTextFieldWithBrowseButton)((Object)this.myClass.getComponent())).getText().trim(), (Object)((EditorTextFieldWithBrowseButton)((Object)this.myMethod.getComponent())).getText().trim()) : null);
        if (this.myChangesRb.isSelected()) {
            Object selectedItem = this.myChangeLists.getSelectedItem();
            configuration.setChangeList("All".equals(selectedItem) ? null : (String)selectedItem);
        } else {
            configuration.setChangeList(null);
        }
        this.myCommonJavaParameters.applyTo(configuration);
    }

    public void resetEditorFrom(TestDiscoveryConfiguration configuration) {
        this.myCommonJavaParameters.reset(configuration);
        this.getModuleSelector().reset(configuration);
        this.myJrePathEditor.setPathOrName(configuration.getAlternativeJrePath(), configuration.isAlternativeJrePathEnabled());
        Pair<String, String> position = configuration.getPosition();
        if (position != null) {
            this.myPositionRb.setSelected(true);
            ((EditorTextFieldWithBrowseButton)((Object)this.myClass.getComponent())).setText((String)position.first);
            ((EditorTextFieldWithBrowseButton)((Object)this.myMethod.getComponent())).setText((String)position.second);
        } else if (this.myChangesRb.isEnabled()) {
            this.myChangesRb.setSelected(true);
        } else {
            this.myPositionRb.setSelected(true);
        }
        String changeList = configuration.getChangeList();
        if (changeList != null) {
            this.myChangeLists.setSelectedItem((Object)changeList);
        } else if (this.myChangesRb.isEnabled()) {
            this.myChangeLists.setSelectedIndex(0);
        }
        this.updateComponents();
    }

    public ModulesComboBox getModulesComponent() {
        return (ModulesComboBox)((Object)this.myModule.getComponent());
    }

    public ConfigurationModuleSelector getModuleSelector() {
        return this.myModuleSelector;
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
    }

    @NotNull
    public JComponent createEditor() {
        JPanel jPanel = this.myWholePanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testDiscovery/TestDiscoveryConfigurable", "createEditor"));
        }
        return jPanel;
    }

    private void applyHelpersTo(TestDiscoveryConfiguration currentState) {
        this.myCommonJavaParameters.applyTo(currentState);
        this.getModuleSelector().applyTo(currentState);
    }
}

