/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.autotest;

import com.intellij.execution.DelayedDocumentWatcher;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.content.Content;
import com.intellij.util.Consumer;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoTestManager {
    private static final String AUTO_TEST_MANAGER_DELAY = "auto.test.manager.delay";
    private static final int AUTO_TEST_MANAGER_DELAY_DEFAULT = 3000;
    private static final Key<ProcessListener> ON_TERMINATION_RESTARTER_KEY = Key.create((String)"auto.test.manager.on.termination.restarter");
    private static final Key<ExecutionEnvironment> EXECUTION_ENVIRONMENT_KEY = Key.create((String)"auto.test.manager.execution.environment");
    private final Project myProject;
    private int myDelayMillis;
    private DelayedDocumentWatcher myDocumentWatcher;

    @NotNull
    public static AutoTestManager getInstance(Project project) {
        AutoTestManager autoTestManager = (AutoTestManager)ServiceManager.getService((Project)project, AutoTestManager.class);
        if (autoTestManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/autotest/AutoTestManager", "getInstance"));
        }
        return autoTestManager;
    }

    public AutoTestManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testframework/autotest/AutoTestManager", "<init>"));
        }
        this.myProject = project;
        this.myDelayMillis = StringUtilRt.parseInt((String)PropertiesComponent.getInstance((Project)project).getValue(AUTO_TEST_MANAGER_DELAY), (int)3000);
        this.myDocumentWatcher = this.createWatcher();
    }

    @NotNull
    private DelayedDocumentWatcher createWatcher() {
        DelayedDocumentWatcher delayedDocumentWatcher = new DelayedDocumentWatcher(this.myProject, this.myDelayMillis, new Consumer<Integer>(){

            public void consume(Integer modificationStamp) {
                AutoTestManager.this.restartAllAutoTests(modificationStamp);
            }
        }, new Condition<VirtualFile>(){

            public boolean value(VirtualFile file) {
                if (ScratchFileService.getInstance().getRootType(file) != null) {
                    return false;
                }
                return FileEditorManager.getInstance((Project)AutoTestManager.this.myProject).isFileOpen(file);
            }
        });
        if (delayedDocumentWatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/autotest/AutoTestManager", "createWatcher"));
        }
        return delayedDocumentWatcher;
    }

    public void setAutoTestEnabled(@NotNull RunContentDescriptor descriptor, @NotNull ExecutionEnvironment environment, boolean enabled) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/execution/testframework/autotest/AutoTestManager", "setAutoTestEnabled"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/testframework/autotest/AutoTestManager", "setAutoTestEnabled"));
        }
        Content content = descriptor.getAttachedContent();
        if (content != null) {
            if (enabled) {
                EXECUTION_ENVIRONMENT_KEY.set((UserDataHolder)content, (Object)environment);
                this.myDocumentWatcher.activate();
            } else {
                ProcessHandler processHandler2;
                EXECUTION_ENVIRONMENT_KEY.set((UserDataHolder)content, null);
                if (!this.hasEnabledAutoTests()) {
                    this.myDocumentWatcher.deactivate();
                }
                if ((processHandler2 = descriptor.getProcessHandler()) != null) {
                    AutoTestManager.clearRestarterListener(processHandler2);
                }
            }
        }
    }

    private boolean hasEnabledAutoTests() {
        RunContentManager contentManager = ExecutionManager.getInstance((Project)this.myProject).getContentManager();
        for (RunContentDescriptor descriptor : contentManager.getAllDescriptors()) {
            if (!AutoTestManager.isAutoTestEnabledForDescriptor(descriptor)) continue;
            return true;
        }
        return false;
    }

    public boolean isAutoTestEnabled(@NotNull RunContentDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/execution/testframework/autotest/AutoTestManager", "isAutoTestEnabled"));
        }
        return AutoTestManager.isAutoTestEnabledForDescriptor(descriptor);
    }

    private static boolean isAutoTestEnabledForDescriptor(@NotNull RunContentDescriptor descriptor) {
        ExecutionEnvironment watched;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/execution/testframework/autotest/AutoTestManager", "isAutoTestEnabledForDescriptor"));
        }
        Content content = descriptor.getAttachedContent();
        if (content != null && (watched = (ExecutionEnvironment)EXECUTION_ENVIRONMENT_KEY.get((UserDataHolder)content)) != null) {
            boolean result2;
            ExecutionEnvironment current = AutoTestManager.getCurrentEnvironment(content);
            boolean bl = result2 = current != null && AutoTestManager.equals(current, watched);
            if (!result2) {
                EXECUTION_ENVIRONMENT_KEY.set((UserDataHolder)content, null);
            }
            return result2;
        }
        return false;
    }

    @Nullable
    private static ExecutionEnvironment getCurrentEnvironment(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/execution/testframework/autotest/AutoTestManager", "getCurrentEnvironment"));
        }
        JComponent component = content.getComponent();
        if (component == null) {
            return null;
        }
        return (ExecutionEnvironment)LangDataKeys.EXECUTION_ENVIRONMENT.getData(DataManager.getInstance().getDataContext((Component)component));
    }

    private static boolean equals(@NotNull ExecutionEnvironment env1, @NotNull ExecutionEnvironment env2) {
        if (env1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env1", "com/intellij/execution/testframework/autotest/AutoTestManager", "equals"));
        }
        if (env2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env2", "com/intellij/execution/testframework/autotest/AutoTestManager", "equals"));
        }
        return env1.getRunProfile() == env2.getRunProfile() && env1.getRunner() == env2.getRunner() && env1.getExecutor() == env2.getExecutor() && env1.getExecutionTarget() == env2.getExecutionTarget();
    }

    private static void clearRestarterListener(@NotNull ProcessHandler processHandler2) {
        if (processHandler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/execution/testframework/autotest/AutoTestManager", "clearRestarterListener"));
        }
        ProcessListener restarterListener = (ProcessListener)ON_TERMINATION_RESTARTER_KEY.get((UserDataHolder)processHandler2, null);
        if (restarterListener != null) {
            processHandler2.removeProcessListener(restarterListener);
            ON_TERMINATION_RESTARTER_KEY.set((UserDataHolder)processHandler2, null);
        }
    }

    private void restartAllAutoTests(int modificationStamp) {
        RunContentManager contentManager = ExecutionManager.getInstance((Project)this.myProject).getContentManager();
        boolean active = false;
        for (RunContentDescriptor descriptor : contentManager.getAllDescriptors()) {
            if (!AutoTestManager.isAutoTestEnabledForDescriptor(descriptor)) continue;
            AutoTestManager.restartAutoTest(descriptor, modificationStamp, this.myDocumentWatcher);
            active = true;
        }
        if (!active) {
            this.myDocumentWatcher.deactivate();
        }
    }

    private static void restartAutoTest(@NotNull RunContentDescriptor descriptor, int modificationStamp, @NotNull DelayedDocumentWatcher documentWatcher) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/execution/testframework/autotest/AutoTestManager", "restartAutoTest"));
        }
        if (documentWatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentWatcher", "com/intellij/execution/testframework/autotest/AutoTestManager", "restartAutoTest"));
        }
        ProcessHandler processHandler2 = descriptor.getProcessHandler();
        if (processHandler2 != null && !processHandler2.isProcessTerminated()) {
            AutoTestManager.scheduleRestartOnTermination(descriptor, processHandler2, modificationStamp, documentWatcher);
        } else {
            AutoTestManager.restart(descriptor);
        }
    }

    private static void scheduleRestartOnTermination(final @NotNull RunContentDescriptor descriptor, final @NotNull ProcessHandler processHandler2, final int modificationStamp, final @NotNull DelayedDocumentWatcher documentWatcher) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/execution/testframework/autotest/AutoTestManager", "scheduleRestartOnTermination"));
        }
        if (processHandler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/execution/testframework/autotest/AutoTestManager", "scheduleRestartOnTermination"));
        }
        if (documentWatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentWatcher", "com/intellij/execution/testframework/autotest/AutoTestManager", "scheduleRestartOnTermination"));
        }
        Object restarterListener = (ProcessListener)ON_TERMINATION_RESTARTER_KEY.get((UserDataHolder)processHandler2);
        if (restarterListener != null) {
            AutoTestManager.clearRestarterListener(processHandler2);
        }
        restarterListener = new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                AutoTestManager.clearRestarterListener(processHandler2);
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (AutoTestManager.isAutoTestEnabledForDescriptor(descriptor) && documentWatcher.isUpToDate(modificationStamp)) {
                            AutoTestManager.restart(descriptor);
                        }
                    }
                }, ModalityState.any());
            }
        };
        ON_TERMINATION_RESTARTER_KEY.set((UserDataHolder)processHandler2, restarterListener);
        processHandler2.addProcessListener(restarterListener);
    }

    private static void restart(@NotNull RunContentDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/execution/testframework/autotest/AutoTestManager", "restart"));
        }
        descriptor.setActivateToolWindowWhenAdded(false);
        descriptor.setReuseToolWindowActivation(true);
        ExecutionUtil.restart((RunContentDescriptor)descriptor);
    }

    int getDelay() {
        return this.myDelayMillis;
    }

    void setDelay(int delay) {
        this.myDelayMillis = delay;
        this.myDocumentWatcher.deactivate();
        this.myDocumentWatcher = this.createWatcher();
        if (this.hasEnabledAutoTests()) {
            this.myDocumentWatcher.activate();
        }
        PropertiesComponent.getInstance((Project)this.myProject).setValue(AUTO_TEST_MANAGER_DELAY, this.myDelayMillis, 3000);
    }
}

