/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.ui.DefaultJreSelectorKt;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.ExtensionsKt;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldWithBrowseButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"'\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u000f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!!\u0001B\n\r\u0001A-\u0011$\u0001M\u0001;\t-aQB\u0004\"\u0006E\u001b\u0011\u0001C\u0001&\u0011\u0011Y\u00012A\u0007\u00021\tI2\u0001#\u0002\u000e\u0003a\u0019Qe\u0001E\u0004\u001b\u0005AB!J\u0006\u0005'!%Q\u0002C\u0005\u0004\u0013\ta\t\u0001\u0007\u0003\n\u0005%\t\u0001\u0004\u0002\r\u0006"}, strings={"Lcom/intellij/execution/ui/DefaultJreSelector;", "", "()V", "addChangeListener", "", "listener", "Ljava/lang/Runnable;", "getDescriptionString", "", "getNameAndDescription", "Lcom/intellij/openapi/util/Pair;", "Companion", "ProjectSdkSelector", "SdkFromModuleDependencies", "SdkFromSourceRootDependencies"}, moduleName="execution-impl")
public abstract class DefaultJreSelector {
    public static final Companion Companion = com.intellij.execution.ui.DefaultJreSelector$Companion.INSTANCE;

    @NotNull
    public abstract Pair<String, String> getNameAndDescription();

    public void addChangeListener(@NotNull Runnable listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getDescriptionString() {
        void description;
        void name;
        Pair<String, String> pair = this.getNameAndDescription();
        String string = ExtensionsKt.component1(pair);
        String string2 = ExtensionsKt.component2(pair);
        pair = null;
        StringBuilder stringBuilder = new StringBuilder().append(" (");
        String string3 = name;
        if (string3 == null) {
            string3 = "<no JRE>";
        }
        return stringBuilder.append(string3).append(" - ").append((String)description).append(")").toString();
    }

    @JvmStatic
    @NotNull
    public static final DefaultJreSelector projectSdk(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return Companion.projectSdk(project);
    }

    @JvmStatic
    @NotNull
    public static final DefaultJreSelector fromModuleDependencies(@NotNull ModulesComboBox moduleComboBox, boolean productionOnly) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)moduleComboBox), (String)"moduleComboBox");
        return Companion.fromModuleDependencies(moduleComboBox, productionOnly);
    }

    @JvmStatic
    @NotNull
    public static final DefaultJreSelector fromSourceRootsDependencies(@NotNull ModulesComboBox moduleComboBox, @NotNull EditorTextFieldWithBrowseButton classSelector) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)moduleComboBox), (String)"moduleComboBox");
        Intrinsics.checkParameterIsNotNull((Object)((Object)classSelector), (String)"classSelector");
        return Companion.fromSourceRootsDependencies(moduleComboBox, classSelector);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"-\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\f\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tAaq\u0001\r\u0001e\t\u0001\u0014AQ\u0004\t\u0005\t6!\u0001\u0005\u0002K1!9\u0001c\u0001\u000e\u0003a\u0011\u0011d\u0001E\u0003\u001b\u0005A2!G\u0002\t\b5\t\u0001\u0004B\u0013\r\t\u000fAI!D\u0001\u0019\u0005e\u0019\u0001RA\u0007\u00021\rI2\u0001C\u0003\u000e\u0003a-Q\u0005\u0003C\u0004\u0011\u0019i\u0011\u0001\u0007\u0002\u001a\u0007!5Q\"\u0001\r\b"}, strings={"Lcom/intellij/execution/ui/DefaultJreSelector$Companion;", "", "()V", "fromModuleDependencies", "Lcom/intellij/execution/ui/DefaultJreSelector;", "moduleComboBox", "Lcom/intellij/application/options/ModulesComboBox;", "productionOnly", "", "fromSourceRootsDependencies", "classSelector", "Lcom/intellij/ui/EditorTextFieldWithBrowseButton;", "projectSdk", "project", "Lcom/intellij/openapi/project/Project;"}, moduleName="execution-impl")
    public static final class Companion {
        public static final Companion INSTANCE;

        @JvmStatic
        @NotNull
        public final DefaultJreSelector projectSdk(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return new ProjectSdkSelector(project);
        }

        @JvmStatic
        @NotNull
        public final DefaultJreSelector fromModuleDependencies(@NotNull ModulesComboBox moduleComboBox, boolean productionOnly) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)moduleComboBox), (String)"moduleComboBox");
            return new SdkFromModuleDependencies(moduleComboBox, (Function0<? extends Boolean>)((Function0)new Function0<Boolean>(productionOnly){
                final /* synthetic */ boolean $productionOnly;

                public final boolean invoke() {
                    return this.$productionOnly;
                }
                {
                    this.$productionOnly = bl;
                    super(0);
                }
            }));
        }

        @JvmStatic
        @NotNull
        public final DefaultJreSelector fromSourceRootsDependencies(@NotNull ModulesComboBox moduleComboBox, @NotNull EditorTextFieldWithBrowseButton classSelector) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)moduleComboBox), (String)"moduleComboBox");
            Intrinsics.checkParameterIsNotNull((Object)((Object)classSelector), (String)"classSelector");
            return new SdkFromSourceRootDependencies(moduleComboBox, classSelector);
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"!\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tAAA\u0003\u0002\u0019\u0005)\u0011\u0001C\u0004\u0006\u0001\u0015\tA\"\u0001\u0007\u00013\u0005A\n!)\u0004\n\u0007!\tQ\"\u0001M\u0002#\u000e\t\u0001BAS\u0015\t-A9!d\t\n\r%)\u0001#B\u000b\u0003\u0019\u0003AJ\u0001'\u0003\n\r%)\u0001#B\u000b\u0003\u0019\u0003AJ\u0001'\u0003\u0019\tE\u001b\u0011\u0001b\u0003*\u0015\u0011\u0019\u0005\u0002C\u0001\u000e\u0003a\r\u0011k\u0001\u0003\u0006\u00015\u0011AQ\u0001\u0005\u0004"}, strings={"Lcom/intellij/execution/ui/DefaultJreSelector$ProjectSdkSelector;", "Lcom/intellij/execution/ui/DefaultJreSelector;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getNameAndDescription", "Lcom/intellij/openapi/util/Pair;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;"}, moduleName="execution-impl")
    public static final class ProjectSdkSelector
    extends DefaultJreSelector {
        @NotNull
        private final Project project;

        @Override
        @NotNull
        public Pair<String, String> getNameAndDescription() {
            return Pair.create((Object)ProjectRootManager.getInstance((Project)this.project).getProjectSdkName(), (Object)"project SDK");
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public ProjectSdkSelector(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            this.project = project;
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"1\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005AY!B\u0001\u0005\u0007\u0015\t\u0001\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0005\b\t-a\u0001!G\u0001\u0019\u0002\u0005n\u0011b\u0001\u0005\u0002\u001b\u0005A\u001a!\u0003\u0004\t\u00055!\u0011BA\u0005\u00021\rA*!U\u0002\u0002\u0011\u000f)\u0003\u0002B\u0006\t\r5\t\u0001TB\r\u0004\u0011\u001di\u0011\u0001g\u0004&\u0017\u0011Y\u0001\u0002C\u0007\t\u0013\rI!\u0001$\u0001\u0019\u0013%\u0011\u0011\"\u0001\r\n1#I#\u0002B\"\t\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0011)\u0001!\u0004\u0002\u0005\t!%\u0011&\u0004\u0003D\u0011!\u0011Q\u0002B\u0005\u0003\u0013\u0005A2\u0001'\u0002R\u0007\u0011)\u0001!\u0004\u0002\u0005\u000b!-\u0001"}, strings={"Lcom/intellij/execution/ui/DefaultJreSelector$SdkFromModuleDependencies;", "Lcom/intellij/execution/ui/DefaultJreSelector;", "moduleComboBox", "Lcom/intellij/application/options/ModulesComboBox;", "productionOnly", "Lkotlin/Function0;", "", "(Lcom/intellij/application/options/ModulesComboBox;Lkotlin/jvm/functions/Function0;)V", "getModuleComboBox", "()Lcom/intellij/application/options/ModulesComboBox;", "getProductionOnly", "()Lkotlin/jvm/functions/Function0;", "addChangeListener", "", "listener", "Ljava/lang/Runnable;", "getNameAndDescription", "Lcom/intellij/openapi/util/Pair;", ""}, moduleName="execution-impl")
    public static class SdkFromModuleDependencies
    extends DefaultJreSelector {
        @NotNull
        private final ModulesComboBox moduleComboBox;
        @NotNull
        private final Function0<? extends Boolean> productionOnly;

        @Override
        @NotNull
        public Pair<String, String> getNameAndDescription() {
            Module module = this.moduleComboBox.getSelectedModule();
            if (module == null) {
                Pair pair = Pair.create(null, (Object)"module not specified");
                Intrinsics.checkExpressionValueIsNotNull((Object)pair, (String)"Pair.create(null, \"module not specified\")");
                return pair;
            }
            Module module2 = module;
            boolean productionOnly = (Boolean)this.productionOnly.invoke();
            Sdk jdkToRun = JavaParameters.getJdkToRunModule((Module)module2, (boolean)productionOnly);
            Sdk moduleJdk = ModuleRootManager.getInstance((Module)module2).getSdk();
            if (moduleJdk == null || jdkToRun == null) {
                Pair pair = Pair.create(null, (Object)"module not specified");
                Intrinsics.checkExpressionValueIsNotNull((Object)pair, (String)"Pair.create(null, \"module not specified\")");
                return pair;
            }
            if (Intrinsics.areEqual((Object)moduleJdk.getHomeDirectory(), (Object)jdkToRun.getHomeDirectory())) {
                Pair pair = Pair.create((Object)moduleJdk.getName(), (Object)("SDK of '" + module2.getName() + "' module"));
                Intrinsics.checkExpressionValueIsNotNull((Object)pair, (String)"Pair.create(moduleJdk.na\u2026'${module.name}' module\")");
                return pair;
            }
            Pair pair = Pair.create((Object)jdkToRun.getName(), (Object)("newest SDK from '" + module2.getName() + "' module" + (productionOnly ? "" : " test") + " dependencies"));
            Intrinsics.checkExpressionValueIsNotNull((Object)pair, (String)"Pair.create(jdkToRun.nam\u2026e \" test\"} dependencies\")");
            return pair;
        }

        @Override
        public void addChangeListener(@NotNull Runnable listener) {
            Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
            this.moduleComboBox.addActionListener(new ActionListener(listener){
                final /* synthetic */ Runnable $listener;

                public final void actionPerformed(ActionEvent it) {
                    this.$listener.run();
                }
                {
                    this.$listener = runnable2;
                }
            });
        }

        @NotNull
        public final ModulesComboBox getModuleComboBox() {
            return this.moduleComboBox;
        }

        @NotNull
        public final Function0<Boolean> getProductionOnly() {
            return this.productionOnly;
        }

        public SdkFromModuleDependencies(@NotNull ModulesComboBox moduleComboBox, @NotNull Function0<? extends Boolean> productionOnly) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)moduleComboBox), (String)"moduleComboBox");
            Intrinsics.checkParameterIsNotNull(productionOnly, (String)"productionOnly");
            this.moduleComboBox = moduleComboBox;
            this.productionOnly = productionOnly;
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!!!B\u0001\t\u0003\u0015\u0001Q!\u0001\u0007\u0002\u0019\u0001I\u0012\u0001'\u0001\"\u0016%\u0019\u0001\"A\u0007\u00021\u0007I1\u0001\u0003\u0002\u000e\u0003a\u0015\u0011kA\u0001\t\u0007\u0015BAa\u0003E\u0005\u001b\u0005AR!G\u0002\t\f5\t\u0001DB\u0015\u000b\t\rC\u0001BA\u0007\u00021\u000b\t6\u0001B\u0003\u0001\u001b\t!9\u0001\u0003\u0003"}, strings={"Lcom/intellij/execution/ui/DefaultJreSelector$SdkFromSourceRootDependencies;", "Lcom/intellij/execution/ui/DefaultJreSelector$SdkFromModuleDependencies;", "moduleComboBox", "Lcom/intellij/application/options/ModulesComboBox;", "classSelector", "Lcom/intellij/ui/EditorTextFieldWithBrowseButton;", "(Lcom/intellij/application/options/ModulesComboBox;Lcom/intellij/ui/EditorTextFieldWithBrowseButton;)V", "getClassSelector", "()Lcom/intellij/ui/EditorTextFieldWithBrowseButton;", "addChangeListener", "", "listener", "Ljava/lang/Runnable;"}, moduleName="execution-impl")
    public static final class SdkFromSourceRootDependencies
    extends SdkFromModuleDependencies {
        @NotNull
        private final EditorTextFieldWithBrowseButton classSelector;

        @Override
        public void addChangeListener(@NotNull Runnable listener) {
            Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
            super.addChangeListener(listener);
            ((EditorTextField)((Object)this.classSelector.getChildComponent())).addDocumentListener((DocumentListener)new DocumentAdapter(listener){
                final /* synthetic */ Runnable $listener;

                public void documentChanged(@Nullable DocumentEvent e) {
                    this.$listener.run();
                }
                {
                    this.$listener = $captured_local_variable$0;
                }
            });
        }

        @NotNull
        public final EditorTextFieldWithBrowseButton getClassSelector() {
            return this.classSelector;
        }

        public SdkFromSourceRootDependencies(final @NotNull ModulesComboBox moduleComboBox, final @NotNull EditorTextFieldWithBrowseButton classSelector) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)moduleComboBox), (String)"moduleComboBox");
            Intrinsics.checkParameterIsNotNull((Object)((Object)classSelector), (String)"classSelector");
            super(moduleComboBox, (Function0<? extends Boolean>)((Function0)new Function0<Boolean>(){

                public final boolean invoke() {
                    return DefaultJreSelectorKt.access$isClassInProductionSources(moduleComboBox, classSelector);
                }
            }));
            this.classSelector = classSelector;
        }
    }
}

