/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetFinder;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetRootsProvider;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ProjectWideFacetListener;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetFinderImpl
extends FacetFinder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.impl.FacetFinderImpl");
    private final Map<FacetTypeId, AllFacetsOfTypeModificationTracker> myAllFacetTrackers = new HashMap<FacetTypeId, AllFacetsOfTypeModificationTracker>();
    private final Map<FacetTypeId, CachedValue<Map<VirtualFile, List<Facet>>>> myCachedMaps = new HashMap<FacetTypeId, CachedValue<Map<VirtualFile, List<Facet>>>>();
    private final Project myProject;
    private final CachedValuesManager myCachedValuesManager;
    private final ModuleManager myModuleManager;

    public FacetFinderImpl(Project project) {
        this.myProject = project;
        this.myCachedValuesManager = CachedValuesManager.getManager((Project)project);
        this.myModuleManager = ModuleManager.getInstance((Project)this.myProject);
    }

    public <F extends Facet> ModificationTracker getAllFacetsOfTypeModificationTracker(FacetTypeId<F> type) {
        AllFacetsOfTypeModificationTracker<F> tracker = this.myAllFacetTrackers.get(type);
        if (tracker == null) {
            tracker = new AllFacetsOfTypeModificationTracker<F>(this.myProject, type);
            Disposer.register((Disposable)this.myProject, tracker);
            this.myAllFacetTrackers.put(type, tracker);
        }
        return tracker;
    }

    private <F extends Facet> Map<VirtualFile, List<Facet>> getRootToFacetsMap(final FacetTypeId<F> type) {
        Map value;
        CachedValue cachedValue = this.myCachedMaps.get(type);
        if (cachedValue == null) {
            cachedValue = this.myCachedValuesManager.createCachedValue((CachedValueProvider)new CachedValueProvider<Map<VirtualFile, List<Facet>>>(){

                public CachedValueProvider.Result<Map<VirtualFile, List<Facet>>> compute() {
                    Map map = FacetFinderImpl.this.computeRootToFacetsMap(type);
                    return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{FacetFinderImpl.this.getAllFacetsOfTypeModificationTracker(type)});
                }
            }, false);
            this.myCachedMaps.put(type, (CachedValue<Map<VirtualFile, List<Facet>>>)cachedValue);
        }
        LOG.assertTrue((value = (Map)cachedValue.getValue()) != null);
        return value;
    }

    @NotNull
    private <F extends Facet> Map<VirtualFile, List<Facet>> computeRootToFacetsMap(FacetTypeId<F> type) {
        Module[] modules = this.myModuleManager.getModules();
        HashMap<VirtualFile, List<Facet>> map = new HashMap<VirtualFile, List<Facet>>();
        for (Module module : modules) {
            Collection facets = FacetManager.getInstance((Module)module).getFacetsByType(type);
            for (Facet facet : facets) {
                for (VirtualFile root : ((FacetRootsProvider)facet).getFacetRoots()) {
                    SmartList list = map.get(root);
                    if (list == null) {
                        list = new SmartList();
                        map.put(root, (List<Facet>)list);
                    }
                    list.add((Facet)facet);
                }
            }
        }
        HashMap<VirtualFile, List<Facet>> hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/FacetFinderImpl", "computeRootToFacetsMap"));
        }
        return hashMap;
    }

    @Nullable
    public <F extends Facet> F findFacet(VirtualFile file, FacetTypeId<F> type) {
        Collection list = this.findFacets(file, (FacetTypeId)type);
        return (F)(list.size() > 0 ? (Facet)list.get(0) : null);
    }

    @NotNull
    public <F extends Facet> List<F> findFacets(VirtualFile file, FacetTypeId<F> type) {
        Map<VirtualFile, List<Facet>> map = this.getRootToFacetsMap(type);
        if (!map.isEmpty()) {
            while (file != null) {
                List<Facet> list = map.get(file);
                if (list != null) {
                    List<Facet> list2 = list;
                    if (list2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/FacetFinderImpl", "findFacets"));
                    }
                    return list2;
                }
                file = file.getParent();
            }
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/FacetFinderImpl", "findFacets"));
        }
        return list;
    }

    private static class AllFacetsOfTypeModificationTracker<F extends Facet>
    extends SimpleModificationTracker
    implements Disposable,
    ProjectWideFacetListener<F> {
        public AllFacetsOfTypeModificationTracker(Project project, FacetTypeId<F> type) {
            ProjectWideFacetListenersRegistry.getInstance((Project)project).registerListener(type, (ProjectWideFacetListener)this, (Disposable)this);
        }

        public void facetAdded(F facet) {
            this.incModificationCount();
        }

        public void facetRemoved(F facet) {
            this.incModificationCount();
        }

        public void facetConfigurationChanged(F facet) {
            this.incModificationCount();
        }

        public void firstFacetAdded() {
        }

        public void beforeFacetRemoved(F facet) {
        }

        public void allFacetsRemoved() {
        }

        public void dispose() {
        }
    }
}

