/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.revertion;

import com.intellij.history.core.Content;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.Paths;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.revertion.Reverter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class DifferenceReverter
extends Reverter {
    private final IdeaGateway myGateway;
    private final List<Difference> myDiffs;
    private final Revision myLeftRevision;

    public DifferenceReverter(Project p, LocalHistoryFacade vcs, IdeaGateway gw, List<Difference> diffs, Revision leftRevision) {
        super(p, vcs, gw);
        this.myGateway = gw;
        this.myDiffs = diffs;
        this.myLeftRevision = leftRevision;
    }

    @Override
    protected Revision getTargetRevision() {
        return this.myLeftRevision;
    }

    @Override
    protected List<VirtualFile> getFilesToClearROStatus() throws IOException {
        LinkedHashSet<VirtualFile> files = new LinkedHashSet<VirtualFile>();
        for (Difference each : this.myDiffs) {
            VirtualFile f;
            Entry l = each.getLeft();
            Entry r = each.getRight();
            VirtualFile virtualFile = f = l == null ? null : this.myGateway.findVirtualFile(l.getPath());
            if (f != null) {
                files.add(f);
            }
            if ((f = r == null ? null : this.myGateway.findVirtualFile(r.getPath())) == null) continue;
            files.add(f);
        }
        return new ArrayList<VirtualFile>(files);
    }

    @Override
    protected void doRevert() throws IOException {
        this.doRevert(true);
    }

    public void doRevert(boolean revertContentChanges) throws IOException {
        THashSet vetoedFiles = new THashSet();
        for (Difference each : ContainerUtil.iterateBackward(this.myDiffs)) {
            Entry l = each.getLeft();
            Entry r = each.getRight();
            if (l == null) {
                this.revertCreation(r, (Set<String>)vetoedFiles);
                continue;
            }
            vetoedFiles.add(l.getPath());
            if (r == null) {
                this.revertDeletion(l);
                continue;
            }
            VirtualFile file = this.myGateway.findOrCreateFileSafely(r.getPath(), r.isDirectory());
            this.revertRename(l, file);
            if (!revertContentChanges) continue;
            this.revertContentChange(l, file);
        }
    }

    private void revertCreation(Entry r, Set<String> vetoedFiles) throws IOException {
        String path = r.getPath();
        for (String each : vetoedFiles) {
            if (!Paths.isParent(path, each)) continue;
            return;
        }
        VirtualFile f = this.myGateway.findVirtualFile(path);
        if (f != null) {
            f.delete((Object)this);
        }
    }

    private void revertDeletion(Entry l) throws IOException {
        VirtualFile f = this.myGateway.findOrCreateFileSafely(l.getPath(), l.isDirectory());
        if (l.isDirectory()) {
            return;
        }
        this.setContent(l, f);
    }

    private void revertRename(Entry l, VirtualFile file) throws IOException {
        String oldName = l.getName();
        if (!oldName.equals(file.getName())) {
            VirtualFile existing = file.getParent().findChild(oldName);
            if (existing != null) {
                existing.delete((Object)this);
            }
            file.rename((Object)this, oldName);
        }
    }

    private void revertContentChange(Entry l, VirtualFile file) throws IOException {
        if (l.isDirectory()) {
            return;
        }
        if (file.getTimeStamp() != l.getTimestamp()) {
            this.setContent(l, file);
        }
    }

    private void setContent(Entry l, VirtualFile file) throws IOException {
        Content c = l.getContent();
        if (!c.isAvailable()) {
            return;
        }
        file.setBinaryContent(c.getBytes(), -1L, l.getTimestamp());
    }
}

