/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nullable;

public class DeleteAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.DeleteAction");

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        DeleteProvider provider = this.getDeleteProvider(dataContext);
        if (provider == null) {
            return;
        }
        try {
            provider.deleteElement(dataContext);
        }
        catch (Throwable t) {
            if (t instanceof StackOverflowError) {
                t.printStackTrace();
            }
            LOG.error(t);
        }
    }

    @Nullable
    protected DeleteProvider getDeleteProvider(DataContext dataContext) {
        return (DeleteProvider)PlatformDataKeys.DELETE_ELEMENT_PROVIDER.getData(dataContext);
    }

    public void update(AnActionEvent event) {
        boolean canDelete;
        String place = event.getPlace();
        Presentation presentation = event.getPresentation();
        if ("ProjectViewPopup".equals(place) || "CommanderPopup".equals(place)) {
            presentation.setText(IdeBundle.message((String)"action.delete.ellipsis", (Object[])new Object[0]));
        } else {
            presentation.setText(IdeBundle.message((String)"action.delete", (Object[])new Object[0]));
        }
        DataContext dataContext = event.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        DeleteProvider provider = this.getDeleteProvider(dataContext);
        if (event.getInputEvent() instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)event.getInputEvent();
            Object component = PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
            if (component instanceof JTextComponent) {
                provider = null;
            }
            if (keyEvent.getKeyCode() == 8) {
                String activeSpeedSearchFilter;
                SpeedSearchSupply searchSupply;
                if (component instanceof JComponent && (searchSupply = SpeedSearchSupply.getSupply((JComponent)((JComponent)component))) != null) {
                    provider = null;
                }
                if (!StringUtil.isEmpty((String)(activeSpeedSearchFilter = (String)SpeedSearchSupply.SPEED_SEARCH_CURRENT_QUERY.getData(dataContext)))) {
                    provider = null;
                }
            }
        }
        if (provider instanceof TitledHandler) {
            presentation.setText(((TitledHandler)provider).getActionTitle());
        }
        boolean bl = canDelete = provider != null && provider.canDeleteElement(dataContext);
        if (ActionPlaces.isPopupPlace((String)event.getPlace())) {
            presentation.setVisible(canDelete);
        } else {
            presentation.setEnabled(canDelete);
        }
    }

    public DeleteAction(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    public DeleteAction() {
    }
}

