/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.diff;

import com.intellij.ide.diff.VirtualFileDiffElement;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class JarFileDiffElement
extends VirtualFileDiffElement {
    public JarFileDiffElement(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/diff/JarFileDiffElement", "<init>"));
        }
        super(file.getFileSystem() == JarFileSystem.getInstance() ? file : JarFileSystem.getInstance().getJarRootForLocalFile(file));
    }

    @Override
    protected VirtualFileDiffElement createElement(VirtualFile file) {
        VirtualFile jar = JarFileSystem.getInstance().getJarRootForLocalFile(file);
        return jar == null ? null : new JarFileDiffElement(file);
    }

    @Override
    protected FileChooserDescriptor getChooserDescriptor() {
        return new FileChooserDescriptor(true, false, true, true, false, false){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return file.isDirectory() || !file.isDirectory() && "jar".equalsIgnoreCase(file.getExtension());
            }
        };
    }
}

