/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.actions;

import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeViewPanel;
import com.intellij.ide.favoritesTreeView.actions.AddAllOpenFilesToFavorites;
import com.intellij.ide.favoritesTreeView.actions.AddAllOpenFilesToNewFavoritesListAction;
import com.intellij.ide.favoritesTreeView.actions.AddToFavoritesAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddAllToFavoritesActionGroup
extends ActionGroup
implements DumbAware {
    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/actions/AddAllToFavoritesActionGroup", "getChildren"));
            }
            return AnAction.EMPTY_ARRAY;
        }
        Project project = e.getProject();
        if (project == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/actions/AddAllToFavoritesActionGroup", "getChildren"));
            }
            return AnAction.EMPTY_ARRAY;
        }
        List<String> listNames = FavoritesManager.getInstance(project).getAvailableFavoritesListNames();
        List<String> availableFavoritesLists = FavoritesManager.getInstance(project).getAvailableFavoritesListNames();
        availableFavoritesLists.remove(FavoritesTreeViewPanel.FAVORITES_LIST_NAME_DATA_KEY.getData(e.getDataContext()));
        if (availableFavoritesLists.isEmpty()) {
            AnAction[] anActionArray = new AnAction[]{new AddAllOpenFilesToNewFavoritesListAction()};
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/actions/AddAllToFavoritesActionGroup", "getChildren"));
            }
            return anActionArray;
        }
        AnAction[] actions = new AnAction[listNames.size() + 2];
        int idx = 0;
        for (String favoritesList : listNames) {
            actions[idx++] = new AddAllOpenFilesToFavorites(favoritesList);
        }
        actions[idx++] = Separator.getInstance();
        actions[idx] = new AddAllOpenFilesToNewFavoritesListAction();
        if (actions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/actions/AddAllToFavoritesActionGroup", "getChildren"));
        }
        return actions;
    }

    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabled(AddToFavoritesAction.canCreateNodes(e));
    }
}

