/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard.importSources;

import com.intellij.ide.util.importProject.RootDetectionProcessor;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaSourceRootDetector;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSourceRootDetectionUtil {
    private static final TokenSet JAVA_FILE_FIRST_TOKEN_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{ElementType.MODIFIER_BIT_SET, ElementType.CLASS_KEYWORD_BIT_SET, TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.AT, JavaTokenType.IMPORT_KEYWORD})});

    private JavaSourceRootDetectionUtil() {
    }

    @NotNull
    public static Collection<JavaModuleSourceRoot> suggestRoots(@NotNull File dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/ide/util/projectWizard/importSources/JavaSourceRootDetectionUtil", "suggestRoots"));
        }
        List detectors = ContainerUtil.findAll((Object[])ProjectStructureDetector.EP_NAME.getExtensions(), JavaSourceRootDetector.class);
        RootDetectionProcessor processor2 = new RootDetectionProcessor(dir, detectors.toArray(new JavaSourceRootDetector[detectors.size()]));
        Map<ProjectStructureDetector, List<DetectedProjectRoot>> rootsMap = processor2.runDetectors();
        HashMap<File, JavaModuleSourceRoot> result2 = new HashMap<File, JavaModuleSourceRoot>();
        for (List<DetectedProjectRoot> roots : rootsMap.values()) {
            for (DetectedProjectRoot root : roots) {
                if (!(root instanceof JavaModuleSourceRoot)) continue;
                JavaModuleSourceRoot sourceRoot = (JavaModuleSourceRoot)root;
                File directory = sourceRoot.getDirectory();
                JavaModuleSourceRoot oldRoot = (JavaModuleSourceRoot)result2.remove(directory);
                if (oldRoot != null) {
                    result2.put(directory, oldRoot.combineWith(sourceRoot));
                    continue;
                }
                result2.put(directory, sourceRoot);
            }
        }
        Collection<JavaModuleSourceRoot> collection = result2.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/importSources/JavaSourceRootDetectionUtil", "suggestRoots"));
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getPackageName(CharSequence text) {
        Lexer lexer = JavaParserDefinition.createLexer(LanguageLevel.JDK_1_3);
        lexer.start(text);
        JavaSourceRootDetectionUtil.skipWhiteSpaceAndComments(lexer);
        IElementType firstToken = lexer.getTokenType();
        if (firstToken != JavaTokenType.PACKAGE_KEYWORD) {
            if (JAVA_FILE_FIRST_TOKEN_SET.contains(firstToken)) {
                return "";
            }
            return null;
        }
        lexer.advance();
        JavaSourceRootDetectionUtil.skipWhiteSpaceAndComments(lexer);
        StringBuilder buffer = StringBuilderSpinAllocator.alloc();
        try {
            while (lexer.getTokenType() == JavaTokenType.IDENTIFIER) {
                buffer.append(text, lexer.getTokenStart(), lexer.getTokenEnd());
                lexer.advance();
                JavaSourceRootDetectionUtil.skipWhiteSpaceAndComments(lexer);
                if (lexer.getTokenType() != JavaTokenType.DOT) break;
                buffer.append('.');
                lexer.advance();
                JavaSourceRootDetectionUtil.skipWhiteSpaceAndComments(lexer);
            }
            String packageName = buffer.toString();
            if (packageName.length() == 0 || StringUtil.endsWithChar((CharSequence)packageName, (char)'.')) {
                String string = null;
                return string;
            }
            String string = packageName;
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buffer);
        }
    }

    public static void skipWhiteSpaceAndComments(Lexer lexer) {
        while (ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(lexer.getTokenType())) {
            lexer.advance();
        }
    }
}

