/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.util.SystemInfo;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class OsNameUsageCollector
extends UsagesCollector {
    OsNameUsageCollector() {
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages() throws CollectUsagesException {
        String osName = SystemInfo.isLinux ? "Linux" : (SystemInfo.isMac ? "Mac OS X" : (SystemInfo.isWindows ? "Windows" : SystemInfo.OS_NAME));
        Set<UsageDescriptor> set = Collections.singleton(new UsageDescriptor(osName, 1));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/OsNameUsageCollector", "getUsages"));
        }
        return set;
    }

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create("user.os.name");
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/OsNameUsageCollector", "getGroupId"));
        }
        return groupDescriptor;
    }
}

