/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.openapi.diff.impl.DiffHighlighterFactory;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;

public class DiffHighlighterFactoryImpl
implements DiffHighlighterFactory {
    private final Project myProject;
    private final FileType myFileType;
    private final VirtualFile myFile;

    public DiffHighlighterFactoryImpl(FileType fileType, VirtualFile file, Project project) {
        this.myFileType = fileType;
        this.myProject = project;
        this.myFile = file;
    }

    @Override
    public EditorHighlighter createHighlighter() {
        if (this.myFileType == null || this.myProject == null) {
            return null;
        }
        if (this.myFile != null && this.myFile.getFileType() == this.myFileType || this.myFile instanceof LightVirtualFile) {
            return EditorHighlighterFactory.getInstance().createEditorHighlighter(this.myProject, this.myFile);
        }
        return EditorHighlighterFactory.getInstance().createEditorHighlighter(this.myProject, this.myFileType);
    }
}

