/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.external;

import com.intellij.openapi.diff.impl.external.ContentExternalizer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.Nullable;

class LocalFileExternalizer
implements ContentExternalizer {
    private final File myFile;

    public LocalFileExternalizer(File file) {
        this.myFile = file;
    }

    @Override
    public File getContentFile() {
        return this.myFile;
    }

    @Nullable
    public static LocalFileExternalizer tryCreate(VirtualFile file) {
        if (file == null || !file.isValid()) {
            return null;
        }
        if (!file.isInLocalFileSystem()) {
            return null;
        }
        return new LocalFileExternalizer(new File(file.getPath().replace('/', File.separatorChar)));
    }

    static boolean canExternalizeAsFile(VirtualFile file) {
        if (file == null || file.isDirectory()) {
            return false;
        }
        FileType fileType = file.getFileType();
        return !fileType.isBinary() || fileType == FileTypes.UNKNOWN;
    }
}

