/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.highlighting;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.impl.ContentChangeListener;
import com.intellij.openapi.diff.impl.fragments.FragmentHighlighter;
import com.intellij.openapi.diff.impl.fragments.FragmentListImpl;
import com.intellij.openapi.diff.impl.fragments.LineFragment;
import com.intellij.openapi.diff.impl.highlighting.DiffPanelState;
import com.intellij.openapi.diff.impl.highlighting.FragmentBoundRenderer;
import com.intellij.openapi.diff.impl.highlighting.FragmentSeparatorsPositionConsumer;
import com.intellij.openapi.diff.impl.highlighting.NumberedFragmentHighlighter;
import com.intellij.openapi.diff.impl.highlighting.PresetBlocksDiffPolicy;
import com.intellij.openapi.diff.impl.processing.DiffPolicy;
import com.intellij.openapi.diff.impl.processing.TextCompareProcessor;
import com.intellij.openapi.diff.impl.splitter.LineBlocks;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.BeforeAfter;
import com.intellij.util.Consumer;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FragmentedDiffPanelState
extends DiffPanelState {
    private List<BeforeAfter<Integer>> myRanges;
    private final NumberedFragmentHighlighter myFragmentHighlighter;
    private FragmentSeparatorsPositionConsumer mySeparatorsPositionConsumer;

    public FragmentedDiffPanelState(ContentChangeListener changeListener, Project project, int diffDividerPolygonsOffset, boolean drawNumber, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/diff/impl/highlighting/FragmentedDiffPanelState", "<init>"));
        }
        super(changeListener, project, diffDividerPolygonsOffset, parentDisposable);
        this.myFragmentHighlighter = new NumberedFragmentHighlighter(this.myAppender1, this.myAppender2, drawNumber);
        this.mySeparatorsPositionConsumer = new FragmentSeparatorsPositionConsumer();
    }

    @Override
    public void setContents(DiffContent content1, DiffContent content2) {
        this.myAppender1.setContent(content1);
        this.myAppender2.setContent(content2);
        this.myFragmentHighlighter.reset();
    }

    private LineBlocks addMarkup(List<LineFragment> lines) {
        this.myFragmentHighlighter.precalculateNumbers(lines);
        Iterator<LineFragment> iterator = lines.iterator();
        while (iterator.hasNext()) {
            LineFragment line = iterator.next();
            this.myFragmentHighlighter.setIsLast(!iterator.hasNext());
            line.highlight((FragmentHighlighter)this.myFragmentHighlighter);
        }
        ArrayList<LineFragment> allLineFragments = new ArrayList<LineFragment>();
        for (LineFragment lineFragment : lines) {
            allLineFragments.add(lineFragment);
            lineFragment.addAllDescendantsTo(allLineFragments);
        }
        this.myFragmentList = FragmentListImpl.fromList(allLineFragments);
        return LineBlocks.fromLineFragments(allLineFragments);
    }

    public void addRangeHighlighter(boolean left, int start, int end, TextAttributes attributes) {
        this.myFragmentHighlighter.addRangeHighlighter(left, start, end, attributes);
    }

    private void resetMarkup() {
        this.myAppender1.resetHighlighters();
        this.myAppender2.resetHighlighters();
    }

    @Override
    @Nullable
    public LineBlocks updateEditors() throws FilesTooBigForDiffException {
        this.resetMarkup();
        this.mySeparatorsPositionConsumer.clear();
        if (this.myAppender1.getEditor() == null || this.myAppender2.getEditor() == null) {
            return null;
        }
        int previousBefore = -1;
        int previousAfter = -1;
        ArrayList<BeforeAfter<TextRange>> ranges = new ArrayList<BeforeAfter<TextRange>>();
        for (int i = 0; i < this.myRanges.size(); ++i) {
            BeforeAfter<Integer> start = this.lineStarts(i);
            BeforeAfter end = i == this.myRanges.size() - 1 ? new BeforeAfter((Object)this.myAppender1.getDocument().getTextLength(), (Object)this.myAppender2.getDocument().getTextLength()) : this.lineStarts(i + 1);
            ranges.add((BeforeAfter<TextRange>)new BeforeAfter((Object)new TextRange(((Integer)start.getBefore()).intValue(), ((Integer)end.getBefore()).intValue()), (Object)new TextRange(((Integer)start.getAfter()).intValue(), ((Integer)end.getAfter()).intValue())));
            if (previousBefore > 0 && previousAfter > 0) {
                final int finalPreviousBefore = previousBefore;
                this.mySeparatorsPositionConsumer.prepare(previousBefore, previousAfter);
                this.myAppender1.setSeparatorMarker(previousBefore, new Consumer<Integer>(){

                    public void consume(Integer integer) {
                        FragmentedDiffPanelState.this.mySeparatorsPositionConsumer.addLeft(finalPreviousBefore, integer);
                    }
                });
                final int finalPreviousAfter = previousAfter;
                this.myAppender2.setSeparatorMarker(previousAfter, new Consumer<Integer>(){

                    public void consume(Integer integer) {
                        FragmentedDiffPanelState.this.mySeparatorsPositionConsumer.addRight(finalPreviousAfter, integer);
                    }
                });
            }
            previousBefore = (Integer)this.myRanges.get(i).getBefore();
            previousAfter = (Integer)this.myRanges.get(i).getAfter();
        }
        PresetBlocksDiffPolicy diffPolicy = new PresetBlocksDiffPolicy(DiffPolicy.LINES_WO_FORMATTING);
        diffPolicy.setRanges(ranges);
        return this.addMarkup(new TextCompareProcessor(this.myComparisonPolicy, (DiffPolicy)diffPolicy, this.myHighlightMode).process(this.myAppender1.getText(), this.myAppender2.getText()));
    }

    private BeforeAfter<Integer> lineStarts(int i) {
        return new BeforeAfter((Object)this.myAppender1.getDocument().getLineStartOffset(((Integer)this.myRanges.get(i).getBefore()).intValue()), (Object)this.myAppender2.getDocument().getLineStartOffset(((Integer)this.myRanges.get(i).getAfter()).intValue()));
    }

    public void setRanges(List<BeforeAfter<Integer>> ranges) {
        this.myRanges = new ArrayList<BeforeAfter<Integer>>();
        if (!ranges.isEmpty() && (Integer)ranges.get(0).getAfter() != 0 && (Integer)ranges.get(0).getBefore() != 0) {
            this.myRanges.add((BeforeAfter<Integer>)new BeforeAfter((Object)0, (Object)0));
        }
        this.myRanges.addAll(ranges);
    }

    public List<Integer> getLeftLines() {
        return this.myFragmentHighlighter.getLeftLines();
    }

    public List<Integer> getRightLines() {
        return this.myFragmentHighlighter.getRightLines();
    }

    public FragmentSeparatorsPositionConsumer getSeparatorsPositionConsumer() {
        return this.mySeparatorsPositionConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawOnDivider(Graphics gr, JComponent component) {
        if (this.myAppender1.getEditor() == null || this.myAppender2.getEditor() == null) {
            return;
        }
        int startLeft = this.getStartVisibleLine(this.myAppender1.getEditor());
        int startRight = this.getStartVisibleLine(this.myAppender2.getEditor());
        int width = component.getWidth();
        int lineHeight = this.myAppender1.getEditor().getLineHeight();
        TreeMap<Integer, FragmentSeparatorsPositionConsumer.TornSeparator> left = this.mySeparatorsPositionConsumer.getLeft();
        int leftScrollOffset = this.myAppender1.getEditor().getScrollingModel().getVerticalScrollOffset();
        int rightScrollOffset = this.myAppender2.getEditor().getScrollingModel().getVerticalScrollOffset();
        Graphics g = gr.create();
        try {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            for (Map.Entry<Integer, FragmentSeparatorsPositionConsumer.TornSeparator> entry : left.entrySet()) {
                FragmentSeparatorsPositionConsumer.TornSeparator tornSeparator = entry.getValue();
                if (tornSeparator.getLeftLine() < startLeft && tornSeparator.getRightLine() < startRight) continue;
                int leftOffset = tornSeparator.getLeftOffset();
                int leftBaseY = this.myAppender1.getEditor().logicalPositionToXY((LogicalPosition)new LogicalPosition((int)tornSeparator.getLeftLine(), (int)0)).y - lineHeight / 2 - leftScrollOffset + this.myDiffDividerPolygonsOffset;
                int rightOffset = tornSeparator.getRightOffset();
                int rightBaseY = this.myAppender2.getEditor().logicalPositionToXY((LogicalPosition)new LogicalPosition((int)tornSeparator.getRightLine(), (int)0)).y - lineHeight / 2 - rightScrollOffset + this.myDiffDividerPolygonsOffset;
                int x1 = 0;
                int x2 = width;
                int y1 = leftBaseY + leftOffset;
                int y2 = rightBaseY + rightOffset;
                if (Math.abs(x2 - x1) < Math.abs(y2 - y1)) {
                    int dx = 3;
                    int dy = 2;
                    if (y2 < y1) {
                        g.setColor(FragmentBoundRenderer.darkerBorder());
                        g.drawLine(x1 + dx, y1 - dy + 3, x2, y2 + 3);
                        g.drawLine(x1, y1 - 3, x2 - dx, y2 + dy - 3);
                        g.drawLine(x1, y1 + 3, x1 + dx, y1 - dy + 3);
                        g.drawLine(x2, y2 - 3, x2 - dx, y2 + dy - 3);
                        g.setColor(FragmentBoundRenderer.darkerBorder().darker());
                        g.drawLine(x1 + dx, y1 - dy + 2, x2, y2 + 2);
                        g.drawLine(x1, y1 - 2, x2 - dx, y2 + dy - 2);
                        g.drawLine(x1, y1 + 2, x1 + dx, y1 - dy + 2);
                        g.drawLine(x2, y2 - 2, x2 - dx, y2 + dy - 2);
                        continue;
                    }
                    g.setColor(FragmentBoundRenderer.darkerBorder());
                    g.drawLine(x1, y1 + 3, x2 - dx, y2 - dy + 3);
                    g.drawLine(x1 + dx, y1 + dy - 3, x2, y2 - 3);
                    g.drawLine(x2, y2 + 3, x2 - dx, y2 - dy + 3);
                    g.drawLine(x1, y1 - 3, x1 + dx, y1 + dy - 3);
                    g.setColor(FragmentBoundRenderer.darkerBorder().darker());
                    g.drawLine(x1, y1 + 2, x2 - dx, y2 - dy + 2);
                    g.drawLine(x1 + dx, y1 + dy - 2, x2, y2 - 2);
                    g.drawLine(x2, y2 + 2, x2 - dx, y2 - dy + 2);
                    g.drawLine(x1, y1 - 2, x1 + dx, y1 + dy - 2);
                    continue;
                }
                g.setColor(FragmentBoundRenderer.darkerBorder());
                g.drawLine(x1, y1 + 3, x2, y2 + 3);
                g.drawLine(x1, y1 - 3, x2, y2 - 3);
                g.setColor(FragmentBoundRenderer.darkerBorder().darker());
                g.drawLine(x1, y1 + 2, x2, y2 + 2);
                g.drawLine(x1, y1 - 2, x2, y2 - 2);
            }
        }
        finally {
            g.dispose();
        }
    }

    private int getStartVisibleLine(Editor editor) {
        int offset = editor.getScrollingModel().getVerticalScrollOffset();
        LogicalPosition logicalPosition = editor.xyToLogicalPosition(new Point(0, offset));
        return logicalPosition.line;
    }
}

