/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.mergeTool;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.ActionButtonPresentation;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.MergeRequest;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeCounter;
import com.intellij.openapi.diff.impl.incrementalMerge.ui.MergePanel2;
import com.intellij.openapi.diff.impl.mergeTool.MergeTool;
import com.intellij.openapi.diff.impl.mergeTool.MergeVersion;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.Convertor;
import java.awt.Component;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeRequestImpl
extends MergeRequest {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.mergeTool.MergeRequestImpl");
    private final DiffContent[] myDiffContents;
    private String myWindowTitle;
    private String[] myVersionTitles;
    private int myResult;
    private String myHelpId;
    @Nullable
    private final ActionButtonPresentation myOkButtonPresentation;
    @Nullable
    private final ActionButtonPresentation myCancelButtonPresentation;

    public MergeRequestImpl(@NotNull String left, @NotNull MergeVersion base, @NotNull String right, @Nullable Project project, @Nullable ActionButtonPresentation okButtonPresentation, @Nullable ActionButtonPresentation cancelButtonPresentation) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "com/intellij/openapi/diff/impl/mergeTool/MergeRequestImpl", "<init>"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/openapi/diff/impl/mergeTool/MergeRequestImpl", "<init>"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "com/intellij/openapi/diff/impl/mergeTool/MergeRequestImpl", "<init>"));
        }
        this((DiffContent)new SimpleContent(left), new MergeContent(base, project), (DiffContent)new SimpleContent(right), project, okButtonPresentation, cancelButtonPresentation);
    }

    public MergeRequestImpl(@NotNull DiffContent left, @NotNull MergeVersion base, @NotNull DiffContent right, @Nullable Project project, @Nullable ActionButtonPresentation okButtonPresentation, @Nullable ActionButtonPresentation cancelButtonPresentation) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "com/intellij/openapi/diff/impl/mergeTool/MergeRequestImpl", "<init>"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/openapi/diff/impl/mergeTool/MergeRequestImpl", "<init>"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "com/intellij/openapi/diff/impl/mergeTool/MergeRequestImpl", "<init>"));
        }
        this(left, new MergeContent(base, project), right, project, okButtonPresentation, cancelButtonPresentation);
    }

    public MergeRequestImpl(@NotNull String left, @NotNull String base, @NotNull String right, @Nullable Project project, @Nullable ActionButtonPresentation okButtonPresentation, @Nullable ActionButtonPresentation cancelButtonPresentation) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "com/intellij/openapi/diff/impl/mergeTool/MergeRequestImpl", "<init>"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/openapi/diff/impl/mergeTool/MergeRequestImpl", "<init>"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "com/intellij/openapi/diff/impl/mergeTool/MergeRequestImpl", "<init>"));
        }
        this(left, base, right, null, project, okButtonPresentation, cancelButtonPresentation);
    }

    public MergeRequestImpl(@NotNull String left, @NotNull String base, @NotNull String right, @Nullable FileType type, @Nullable Project project, @Nullable ActionButtonPresentation okButtonPresentation, @Nullable ActionButtonPresentation cancelButtonPresentation) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "com/intellij/openapi/diff/impl/mergeTool/MergeRequestImpl", "<init>"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/openapi/diff/impl/mergeTool/MergeRequestImpl", "<init>"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "com/intellij/openapi/diff/impl/mergeTool/MergeRequestImpl", "<init>"));
        }
        this((DiffContent)new SimpleContent(left, type), (DiffContent)new SimpleContent(base, type), (DiffContent)new SimpleContent(right, type), project, okButtonPresentation, cancelButtonPresentation);
    }

    private MergeRequestImpl(@NotNull DiffContent left, @NotNull DiffContent base, @NotNull DiffContent right, @Nullable Project project, @Nullable ActionButtonPresentation okButtonPresentation, @Nullable ActionButtonPresentation cancelButtonPresentation) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "com/intellij/openapi/diff/impl/mergeTool/MergeRequestImpl", "<init>"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/openapi/diff/impl/mergeTool/MergeRequestImpl", "<init>"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "com/intellij/openapi/diff/impl/mergeTool/MergeRequestImpl", "<init>"));
        }
        super(project);
        this.myDiffContents = new DiffContent[3];
        this.myWindowTitle = null;
        this.myVersionTitles = null;
        this.myResult = 1;
        this.myOkButtonPresentation = okButtonPresentation;
        this.myCancelButtonPresentation = cancelButtonPresentation;
        this.myDiffContents[0] = left;
        this.myDiffContents[1] = base;
        this.myDiffContents[2] = right;
        if (MergeTool.LOG.isDebugEnabled()) {
            VirtualFile file = base.getFile();
            MergeTool.LOG.debug(new Throwable(base.getClass() + " - writable: " + base.getDocument().isWritable() + ", contentType: " + base.getContentType() + ", file: " + (file != null ? "valid - " + file.isValid() : "null") + ", presentation: " + this.myOkButtonPresentation + "-" + this.myCancelButtonPresentation));
        }
    }

    @NotNull
    public DiffContent[] getContents() {
        if (this.myDiffContents == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/mergeTool/MergeRequestImpl", "getContents"));
        }
        return this.myDiffContents;
    }

    public String[] getContentTitles() {
        return this.myVersionTitles;
    }

    public void setVersionTitles(String[] versionTitles) {
        this.myVersionTitles = versionTitles;
    }

    public String getWindowTitle() {
        return this.myWindowTitle;
    }

    public void setWindowTitle(String windowTitle) {
        this.myWindowTitle = windowTitle;
    }

    public void setResult(int result2) {
        if (result2 == 0) {
            this.applyChanges();
        }
        this.myResult = result2;
    }

    public void applyChanges() {
        MergeContent mergeContent = this.getMergeContent();
        if (mergeContent != null) {
            mergeContent.applyChanges();
        }
    }

    public int getResult() {
        return this.myResult;
    }

    @Nullable
    private MergeContent getMergeContent() {
        if (this.myDiffContents[1] instanceof MergeContent) {
            return (MergeContent)this.myDiffContents[1];
        }
        return null;
    }

    @Nullable
    public DiffContent getResultContent() {
        return this.getMergeContent();
    }

    public void restoreOriginalContent() {
        MergeContent mergeContent = this.getMergeContent();
        if (mergeContent == null) {
            return;
        }
        mergeContent.restoreOriginalContent();
    }

    private static void configureAction(DialogBuilder builder, DialogBuilder.CustomizableAction customizableAction, ActionButtonPresentation presentation) {
        char mnemonic;
        customizableAction.setText(presentation.getName());
        String actionName = presentation.getName();
        int index = actionName.indexOf(38);
        if (index >= 0 && index < actionName.length() - 1) {
            mnemonic = actionName.charAt(index + 1);
            actionName = actionName.substring(0, index) + actionName.substring(index + 1);
        } else {
            mnemonic = '\u0000';
        }
        Action action = ((DialogBuilder.ActionDescriptor)customizableAction).getAction(builder.getDialogWrapper());
        action.putValue("Name", actionName);
        if (mnemonic > '\u0000') {
            action.putValue("MnemonicKey", mnemonic);
        }
    }

    public void setActions(DialogBuilder builder, MergePanel2 mergePanel) {
        this.setActions(builder, mergePanel, null);
    }

    public void setActions(final DialogBuilder builder, MergePanel2 mergePanel, final Convertor<DialogWrapper, Boolean> preOkHook) {
        builder.removeAllActions();
        if (this.myOkButtonPresentation != null) {
            if (builder.getOkAction() == null) {
                builder.addOkAction();
            }
            MergeRequestImpl.configureAction(builder, builder.getOkAction(), this.myOkButtonPresentation);
            builder.setOkOperation(new Runnable(){

                @Override
                public void run() {
                    if (preOkHook != null && !((Boolean)preOkHook.convert((Object)builder.getDialogWrapper())).booleanValue()) {
                        return;
                    }
                    MergeRequestImpl.this.myOkButtonPresentation.run(builder.getDialogWrapper());
                }
            });
        }
        if (this.myCancelButtonPresentation != null) {
            if (builder.getCancelAction() == null) {
                builder.addCancelAction();
            }
            MergeRequestImpl.configureAction(builder, builder.getCancelAction(), this.myCancelButtonPresentation);
            builder.setCancelOperation(new Runnable(){

                @Override
                public void run() {
                    MergeRequestImpl.this.myCancelButtonPresentation.run(builder.getDialogWrapper());
                }
            });
        }
        if (this.getMergeContent() != null && mergePanel.getMergeList() != null) {
            new AllResolvedListener(mergePanel, builder.getDialogWrapper());
        }
    }

    public String getHelpId() {
        return this.myHelpId;
    }

    public void setHelpId(@Nullable @NonNls String helpId) {
        this.myHelpId = helpId;
    }

    private static class AllResolvedListener
    implements ChangeCounter.Listener,
    Runnable {
        private final MergePanel2 myMergePanel;
        private final DialogWrapper myDialogWrapper;
        private boolean myWasInvoked = false;

        private AllResolvedListener(MergePanel2 mergePanel, DialogWrapper dialogWrapper) {
            this.myMergePanel = mergePanel;
            this.myDialogWrapper = dialogWrapper;
            ChangeCounter changeCounter = ChangeCounter.getOrCreate(this.myMergePanel.getMergeList());
            changeCounter.removeListener(this);
            changeCounter.addListener(this);
        }

        @Override
        public void run() {
            if (this.myWasInvoked) {
                return;
            }
            if (!this.getWholePanel().isDisplayable()) {
                return;
            }
            this.myWasInvoked = true;
            ChangeCounter.getOrCreate(this.myMergePanel.getMergeList()).removeListener(this);
            int doApply = Messages.showOkCancelDialog((Component)this.getWholePanel(), (String)DiffBundle.message((String)"merge.all.changes.have.processed.save.and.finish.confirmation.text", (Object[])new Object[0]), (String)DiffBundle.message((String)"all.changes.processed.dialog.title", (Object[])new Object[0]), (String)DiffBundle.message((String)"merge.save.and.finish.button", (Object[])new Object[0]), (String)DiffBundle.message((String)"merge.continue.button", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            if (doApply != 0) {
                return;
            }
            this.myDialogWrapper.close(0);
        }

        private JComponent getWholePanel() {
            return this.myMergePanel.getComponent();
        }

        @Override
        public void onCountersChanged(ChangeCounter counter) {
            if (this.myWasInvoked) {
                return;
            }
            if (counter.getChangeCounter() != 0 || counter.getConflictCounter() != 0) {
                return;
            }
            ApplicationManager.getApplication().invokeLater((Runnable)this);
        }
    }

    public static class MergeContent
    extends DiffContent {
        @NotNull
        private final MergeVersion myTarget;
        private final Document myWorkingDocument;
        private final Project myProject;

        public MergeContent(@NotNull MergeVersion target, Project project) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/openapi/diff/impl/mergeTool/MergeRequestImpl$MergeContent", "<init>"));
            }
            this.myTarget = target;
            this.myProject = project;
            this.myWorkingDocument = this.myTarget.createWorkingDocument(project);
            LOG.assertTrue(this.myWorkingDocument.isWritable());
        }

        public void applyChanges() {
            this.myTarget.applyText(this.myWorkingDocument.getText(), this.myProject);
        }

        public Document getDocument() {
            return this.myWorkingDocument;
        }

        public OpenFileDescriptor getOpenFileDescriptor(int offset) {
            VirtualFile file = this.getFile();
            if (file == null) {
                return null;
            }
            return new OpenFileDescriptor(this.myProject, file, offset);
        }

        public VirtualFile getFile() {
            return this.myTarget.getFile();
        }

        @Nullable
        public FileType getContentType() {
            return this.myTarget.getContentType();
        }

        public byte[] getBytes() throws IOException {
            return this.myTarget.getBytes();
        }

        public void restoreOriginalContent() {
            this.myTarget.restoreOriginalContent(this.myProject);
        }
    }
}

