/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483647)
public class ModuleDataService
extends AbstractProjectDataService<ModuleData, Module> {
    public static final com.intellij.openapi.util.Key<ModuleData> MODULE_DATA_KEY = com.intellij.openapi.util.Key.create((String)"MODULE_DATA_KEY");
    private static final Logger LOG = Logger.getInstance((String)("#" + ModuleDataService.class.getName()));

    @NotNull
    public Key<ModuleData> getTargetDataKey() {
        Key key = ProjectKeys.MODULE;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<ModuleData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "importData"));
        }
        if (toImport.isEmpty()) {
            return;
        }
        Collection<DataNode<ModuleData>> toCreate = ModuleDataService.filterExistingModules(toImport, modelsProvider);
        if (!toCreate.isEmpty()) {
            ModuleDataService.createModules(toCreate, modelsProvider);
        }
        for (DataNode<ModuleData> node : toImport) {
            Module module = modelsProvider.findIdeModule((ModuleData)node.getData());
            if (module == null) continue;
            ModuleDataService.syncPaths(module, modelsProvider, (ModuleData)node.getData());
        }
    }

    private static void createModules(@NotNull Collection<DataNode<ModuleData>> toCreate, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toCreate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toCreate", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "createModules"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "createModules"));
        }
        for (DataNode<ModuleData> module : toCreate) {
            ModuleData data = (ModuleData)module.getData();
            Module created = modelsProvider.newModule(data.getModuleFilePath(), data.getModuleTypeId());
            final ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(created);
            modifiableRootModel.inheritSdk();
            ModuleDataService.setModuleOptions(created, module);
            RootPolicy<Object> visitor = new RootPolicy<Object>(){

                public Object visitLibraryOrderEntry(LibraryOrderEntry libraryOrderEntry, Object value) {
                    modifiableRootModel.removeOrderEntry((OrderEntry)libraryOrderEntry);
                    return value;
                }

                public Object visitModuleOrderEntry(ModuleOrderEntry moduleOrderEntry, Object value) {
                    modifiableRootModel.removeOrderEntry((OrderEntry)moduleOrderEntry);
                    return value;
                }
            };
            for (OrderEntry orderEntry : modifiableRootModel.getOrderEntries()) {
                orderEntry.accept((RootPolicy)visitor, null);
            }
        }
    }

    @NotNull
    private static Collection<DataNode<ModuleData>> filterExistingModules(@NotNull Collection<DataNode<ModuleData>> modules, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "filterExistingModules"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "filterExistingModules"));
        }
        ArrayList result2 = ContainerUtilRt.newArrayList();
        for (DataNode<ModuleData> node : modules) {
            ModuleData moduleData = (ModuleData)node.getData();
            Module module = modelsProvider.findIdeModule(moduleData);
            if (module == null) {
                result2.add(node);
                continue;
            }
            ModuleDataService.setModuleOptions(module, node);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "filterExistingModules"));
        }
        return arrayList;
    }

    private static void syncPaths(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ModuleData data) {
        String testCompileOutputPath;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "syncPaths"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "syncPaths"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "syncPaths"));
        }
        ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module);
        CompilerModuleExtension extension = (CompilerModuleExtension)modifiableRootModel.getModuleExtension(CompilerModuleExtension.class);
        if (extension == null) {
            modifiableRootModel.dispose();
            String errorMsg = String.format("Can't sync paths for module '%s'. Reason: no compiler extension is found for it", module.getName());
            throw new RuntimeException(errorMsg);
        }
        String compileOutputPath = data.getCompileOutputPath(ExternalSystemSourceType.SOURCE);
        if (compileOutputPath != null) {
            extension.setCompilerOutputPath(VfsUtilCore.pathToUrl((String)compileOutputPath));
        }
        if ((testCompileOutputPath = data.getCompileOutputPath(ExternalSystemSourceType.TEST)) != null) {
            extension.setCompilerOutputPathForTests(VfsUtilCore.pathToUrl((String)testCompileOutputPath));
        }
        extension.inheritCompilerOutputPath(data.isInheritProjectCompileOutputPath());
    }

    @NotNull
    public Computable<Collection<Module>> computeOrphanData(final @NotNull Collection<DataNode<ModuleData>> toImport, final @NotNull ProjectData projectData, @NotNull Project project, final @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "computeOrphanData"));
        }
        if (projectData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "computeOrphanData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "computeOrphanData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "computeOrphanData"));
        }
        Computable<Collection<Module>> computable = new Computable<Collection<Module>>(){

            public Collection<Module> compute() {
                List orphanIdeModules = ContainerUtil.newSmartList();
                for (Module module : modelsProvider.getModules()) {
                    if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)projectData.getOwner(), (Module)module)) continue;
                    String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
                    if (!projectData.getLinkedExternalProjectPath().equals(rootProjectPath)) continue;
                    final String projectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
                    final String projectId = ExternalSystemApiUtil.getExternalProjectId((Module)module);
                    DataNode found = (DataNode)ContainerUtil.find((Iterable)toImport, (Condition)new Condition<DataNode<ModuleData>>(){

                        public boolean value(DataNode<ModuleData> node) {
                            ModuleData moduleData = (ModuleData)node.getData();
                            return moduleData.getId().equals(projectId) && moduleData.getLinkedExternalProjectPath().equals(projectPath);
                        }
                    });
                    if (found != null) continue;
                    orphanIdeModules.add(module);
                }
                return orphanIdeModules;
            }
        };
        if (computable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "computeOrphanData"));
        }
        return computable;
    }

    public void removeData(@NotNull Computable<Collection<Module>> toRemoveComputable, @NotNull Collection<DataNode<ModuleData>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project, final @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toRemoveComputable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemoveComputable", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "removeData"));
        }
        if (toIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toIgnore", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "removeData"));
        }
        if (projectData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "removeData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "removeData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "removeData"));
        }
        Collection toRemove = (Collection)toRemoveComputable.compute();
        SmartList modules = new SmartList(toRemove);
        for (DataNode<ModuleData> moduleDataNode : toIgnore) {
            Module module = modelsProvider.findIdeModule((ModuleData)moduleDataNode.getData());
            ContainerUtil.addIfNotNull((Collection)modules, (Object)module);
        }
        if (modules.isEmpty()) {
            return;
        }
        ContainerUtil.removeDuplicates((Collection)modules);
        for (Module module : modules) {
            if (module.isDisposed()) continue;
            ModuleDataService.unlinkModuleFromExternalSystem(module);
        }
        ModuleDataService.ruleOrphanModules((List<Module>)modules, project, projectData.getOwner(), new Consumer<List<Module>>(){

            public void consume(List<Module> modules) {
                ModifiableModuleModel moduleModel = modelsProvider.getModifiableModuleModel();
                for (Module module : modules) {
                    if (module.isDisposed()) continue;
                    String path = module.getModuleFilePath();
                    moduleModel.disposeModule(module);
                    ModuleBuilder.deleteModuleFile((String)path);
                }
            }
        });
    }

    private static void ruleOrphanModules(final @NotNull List<Module> orphanModules, final @NotNull Project project, final @NotNull ProjectSystemId externalSystemId, final @NotNull Consumer<List<Module>> result2) {
        if (orphanModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orphanModules", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "ruleOrphanModules"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "ruleOrphanModules"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "ruleOrphanModules"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "ruleOrphanModules"));
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                List toRemove = ContainerUtil.newSmartList();
                if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                    toRemove.addAll(orphanModules);
                } else {
                    final JPanel content = new JPanel(new GridBagLayout());
                    content.add((Component)new JLabel(ExternalSystemBundle.message((String)"orphan.modules.text", (Object[])new Object[]{externalSystemId.getReadableName()})), ExternalSystemUiUtil.getFillLineConstraints(0));
                    CheckBoxList orphanModulesList = new CheckBoxList();
                    orphanModulesList.setSelectionMode(2);
                    orphanModulesList.setItems(orphanModules, (Function)new Function<Module, String>(){

                        public String fun(Module module) {
                            return module.getName();
                        }
                    });
                    for (Module module : orphanModules) {
                        orphanModulesList.setItemSelected((Object)module, true);
                    }
                    orphanModulesList.setBorder(IdeBorderFactory.createEmptyBorder((int)8));
                    content.add((Component)orphanModulesList, ExternalSystemUiUtil.getFillLineConstraints(0));
                    content.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)8, (int)0));
                    DialogWrapper dialog = new DialogWrapper(project){
                        {
                            super(arg0);
                            this.setTitle(ExternalSystemBundle.message((String)"import.title", (Object[])new Object[]{externalSystemId.getReadableName()}));
                            this.init();
                        }

                        @Nullable
                        protected JComponent createCenterPanel() {
                            return new JBScrollPane((Component)content);
                        }

                        @NotNull
                        protected Action[] createActions() {
                            Action[] actionArray = new Action[]{this.getOKAction()};
                            if (actionArray == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService$4$2", "createActions"));
                            }
                            return actionArray;
                        }
                    };
                    dialog.showAndGet();
                    for (int i = 0; i < orphanModules.size(); ++i) {
                        Module module = (Module)orphanModules.get(i);
                        if (!orphanModulesList.isItemSelected(i)) continue;
                        toRemove.add(module);
                    }
                }
                result2.consume((Object)toRemove);
            }
        });
    }

    private static void unlinkModuleFromExternalSystem(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "unlinkModuleFromExternalSystem"));
        }
        module.clearOption("external.system.id");
        module.clearOption("external.linked.project.id");
        module.clearOption("external.linked.project.path");
        module.clearOption("external.root.project.path");
        module.clearOption("external.system.module.group");
        module.clearOption("external.system.module.version");
    }

    private static void setModuleOptions(Module module, DataNode<ModuleData> moduleDataNode) {
        ModuleData moduleData = (ModuleData)moduleDataNode.getData();
        module.putUserData(MODULE_DATA_KEY, (Object)moduleData);
        module.setOption("external.system.id", moduleData.getOwner().toString());
        module.setOption("external.linked.project.id", moduleData.getId());
        module.setOption("external.linked.project.path", moduleData.getLinkedExternalProjectPath());
        ProjectData projectData = (ProjectData)moduleDataNode.getData(ProjectKeys.PROJECT);
        module.setOption("external.root.project.path", projectData != null ? projectData.getLinkedExternalProjectPath() : "");
        if (moduleData.getGroup() != null) {
            module.setOption("external.system.module.group", moduleData.getGroup());
        }
        if (moduleData.getVersion() != null) {
            module.setOption("external.system.module.version", moduleData.getVersion());
        }
        module.clearOption("org.jetbrains.idea.maven.project.MavenProjectsManager.isMavenModule");
    }
}

