/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.util.ActionCallback;
import java.util.IdentityHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Settings {
    public static final DataKey<Settings> KEY = DataKey.create((String)"settings.editor");
    private final ConfigurableGroup[] myGroups;
    private final IdentityHashMap<UnnamedConfigurable, ConfigurableWrapper> myMap;

    protected Settings(ConfigurableGroup ... groups) {
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/openapi/options/ex/Settings", "<init>"));
        }
        this.myMap = new IdentityHashMap();
        this.myGroups = groups;
    }

    @Nullable
    public final <T extends Configurable> T find(@NotNull Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/options/ex/Settings", "find"));
        }
        return this.unwrap(new ConfigurableVisitor.ByType(type).find(this.myGroups), type);
    }

    @Nullable
    public final Configurable find(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/options/ex/Settings", "find"));
        }
        return this.unwrap(new ConfigurableVisitor.ByID(id).find(this.myGroups), Configurable.class);
    }

    @NotNull
    public final ActionCallback select(Configurable configurable) {
        ActionCallback actionCallback = configurable != null ? this.selectImpl(Settings.choose(configurable, (Configurable)this.myMap.get(configurable))) : ActionCallback.REJECTED;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ex/Settings", "select"));
        }
        return actionCallback;
    }

    protected abstract ActionCallback selectImpl(Configurable var1);

    private <T extends Configurable> T unwrap(Configurable configurable, Class<T> type) {
        Configurable result2 = (Configurable)ConfigurableWrapper.cast(type, (UnnamedConfigurable)configurable);
        if (result2 != null && configurable instanceof ConfigurableWrapper) {
            this.myMap.put((UnnamedConfigurable)result2, (ConfigurableWrapper)configurable);
        }
        return (T)result2;
    }

    private static Configurable choose(Configurable configurable, Configurable variant) {
        return variant != null ? variant : configurable;
    }
}

