/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExternalLibraryDescriptor {
    private final String myLibraryGroupId;
    private final String myLibraryArtifactId;
    private final String myMinVersion;
    private final String myMaxVersion;

    public ExternalLibraryDescriptor(String libraryGroupId, String libraryArtifactId) {
        this(libraryGroupId, libraryArtifactId, null, null);
    }

    public ExternalLibraryDescriptor(@NotNull String libraryGroupId, @NotNull String libraryArtifactId, @Nullable String minVersion, @Nullable String maxVersion) {
        if (libraryGroupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryGroupId", "com/intellij/openapi/roots/ExternalLibraryDescriptor", "<init>"));
        }
        if (libraryArtifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryArtifactId", "com/intellij/openapi/roots/ExternalLibraryDescriptor", "<init>"));
        }
        this.myLibraryGroupId = libraryGroupId;
        this.myLibraryArtifactId = libraryArtifactId;
        this.myMinVersion = minVersion;
        this.myMaxVersion = maxVersion;
    }

    @NotNull
    public String getLibraryGroupId() {
        String string = this.myLibraryGroupId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ExternalLibraryDescriptor", "getLibraryGroupId"));
        }
        return string;
    }

    @NotNull
    public String getLibraryArtifactId() {
        String string = this.myLibraryArtifactId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ExternalLibraryDescriptor", "getLibraryArtifactId"));
        }
        return string;
    }

    @Nullable
    public String getMinVersion() {
        return this.myMinVersion;
    }

    @Nullable
    public String getMaxVersion() {
        return this.myMaxVersion;
    }

    public String getPresentableName() {
        return this.myLibraryArtifactId;
    }

    @NotNull
    public abstract List<String> getLibraryClassesRoots();
}

