/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries.ui;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class OrderRoot {
    private final VirtualFile myFile;
    private final OrderRootType myType;
    private final boolean myJarDirectory;

    public OrderRoot(@NotNull VirtualFile file, @NotNull OrderRootType type) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/libraries/ui/OrderRoot", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/roots/libraries/ui/OrderRoot", "<init>"));
        }
        this(file, type, false);
    }

    public OrderRoot(@NotNull VirtualFile file, @NotNull OrderRootType type, boolean jarDirectory) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/libraries/ui/OrderRoot", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/roots/libraries/ui/OrderRoot", "<init>"));
        }
        this.myFile = file;
        this.myType = type;
        this.myJarDirectory = jarDirectory;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/libraries/ui/OrderRoot", "getFile"));
        }
        return virtualFile;
    }

    @NotNull
    public OrderRootType getType() {
        OrderRootType orderRootType = this.myType;
        if (orderRootType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/libraries/ui/OrderRoot", "getType"));
        }
        return orderRootType;
    }

    public boolean isJarDirectory() {
        return this.myJarDirectory;
    }
}

