/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.ArtifactEditorFindUsagesActionBase;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.ArtifactsTreeNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ArtifactSourceItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.LibrarySourceItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ModuleOutputSourceItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.SourceItemNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.SourceItemsTree;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.ui.treeStructure.Tree;
import java.util.List;

public class SourceItemFindUsagesAction
extends ArtifactEditorFindUsagesActionBase {
    private final SourceItemsTree myTree;

    public SourceItemFindUsagesAction(SourceItemsTree tree, Project project, ArtifactsStructureConfigurableContext artifactContext) {
        super((Tree)tree, project, artifactContext);
        this.myTree = tree;
    }

    @Override
    protected ProjectStructureElement getSelectedElement() {
        List<SourceItemNode> nodes = this.myTree.getSelectedSourceItemNodes();
        if (nodes.size() != 1) {
            return null;
        }
        ArtifactsTreeNode node = nodes.get(0);
        if (!(node instanceof SourceItemNode)) {
            return null;
        }
        PackagingSourceItem sourceItem = ((SourceItemNode)node).getSourceItem();
        if (sourceItem == null) {
            return null;
        }
        StructureConfigurableContext context = this.getContext();
        if (sourceItem instanceof ModuleOutputSourceItem) {
            return new ModuleProjectStructureElement(context, ((ModuleOutputSourceItem)sourceItem).getModule());
        }
        if (sourceItem instanceof LibrarySourceItem) {
            return new LibraryProjectStructureElement(context, ((LibrarySourceItem)sourceItem).getLibrary());
        }
        if (sourceItem instanceof ArtifactSourceItem) {
            return this.myArtifactContext.getOrCreateArtifactElement(((ArtifactSourceItem)sourceItem).getArtifact());
        }
        return null;
    }
}

