/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.updateSettings.UpdateStrategyCustomization;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.CheckForUpdateResult;
import com.intellij.openapi.updateSettings.impl.Product;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdatesInfo;
import com.intellij.openapi.updateSettings.impl.UserUpdateSettings;
import com.intellij.openapi.util.BuildNumber;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UpdateStrategy {
    private final int myMajorVersion;
    private final BuildNumber myCurrentBuild;
    private final UpdatesInfo myUpdatesInfo;
    private final UserUpdateSettings myUpdateSettings;
    private final ChannelStatus myChannelStatus;
    private final UpdateStrategyCustomization myStrategyCustomization;

    public UpdateStrategy(int majorVersion, @NotNull BuildNumber currentBuild, @NotNull UpdatesInfo updatesInfo, @NotNull UserUpdateSettings updateSettings) {
        if (currentBuild == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentBuild", "com/intellij/openapi/updateSettings/impl/UpdateStrategy", "<init>"));
        }
        if (updatesInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updatesInfo", "com/intellij/openapi/updateSettings/impl/UpdateStrategy", "<init>"));
        }
        if (updateSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateSettings", "com/intellij/openapi/updateSettings/impl/UpdateStrategy", "<init>"));
        }
        this(majorVersion, currentBuild, updatesInfo, updateSettings, UpdateStrategyCustomization.getInstance());
    }

    public UpdateStrategy(int majorVersion, @NotNull BuildNumber currentBuild, @NotNull UpdatesInfo updatesInfo, @NotNull UserUpdateSettings updateSettings, @NotNull UpdateStrategyCustomization customization) {
        if (currentBuild == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentBuild", "com/intellij/openapi/updateSettings/impl/UpdateStrategy", "<init>"));
        }
        if (updatesInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updatesInfo", "com/intellij/openapi/updateSettings/impl/UpdateStrategy", "<init>"));
        }
        if (updateSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateSettings", "com/intellij/openapi/updateSettings/impl/UpdateStrategy", "<init>"));
        }
        if (customization == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customization", "com/intellij/openapi/updateSettings/impl/UpdateStrategy", "<init>"));
        }
        this.myMajorVersion = majorVersion;
        this.myCurrentBuild = currentBuild;
        this.myUpdatesInfo = updatesInfo;
        this.myUpdateSettings = updateSettings;
        this.myChannelStatus = updateSettings.getSelectedChannelStatus();
        this.myStrategyCustomization = customization;
    }

    public final CheckForUpdateResult checkForUpdates() {
        Product product = this.myUpdatesInfo.getProduct(this.myCurrentBuild.getProductCode());
        if (product == null || product.getChannels().isEmpty()) {
            return new CheckForUpdateResult(State.NOTHING_LOADED, null);
        }
        UpdateChannel updatedChannel = null;
        BuildInfo newBuild = null;
        List<UpdateChannel> activeChannels = this.getActiveChannels(product);
        for (UpdateChannel channel : activeChannels) {
            if (!this.hasNewVersion(channel)) continue;
            updatedChannel = channel;
            newBuild = updatedChannel.getLatestBuild();
            break;
        }
        UpdateChannel channelToPropose = null;
        for (UpdateChannel channel : product.getChannels()) {
            if (this.myUpdateSettings.getKnownChannelsIds().contains(channel.getId()) || channel.getMajorVersion() < this.myMajorVersion || channel.getStatus().compareTo(this.myChannelStatus) < 0 || !this.hasNewVersion(channel) || channelToPropose != null && !UpdateStrategy.isBetter(channelToPropose, channel)) continue;
            channelToPropose = channel;
        }
        return new CheckForUpdateResult(newBuild, updatedChannel, channelToPropose, product.getAllChannelIds());
    }

    private List<UpdateChannel> getActiveChannels(Product product) {
        ArrayList<UpdateChannel> result2 = new ArrayList<UpdateChannel>();
        for (UpdateChannel channel : product.getChannels()) {
            if (channel.getMajorVersion() < this.myMajorVersion || channel.getStatus().compareTo(this.myChannelStatus) < 0 || !this.myStrategyCustomization.allowMajorVersionUpdate() && channel.getMajorVersion() != this.myMajorVersion && (channel.getStatus() != ChannelStatus.EAP || this.myChannelStatus != ChannelStatus.EAP)) continue;
            if (channel.getMajorVersion() == this.myMajorVersion && channel.getStatus().compareTo(this.myChannelStatus) == 0) {
                result2.add(0, channel);
                continue;
            }
            result2.add(channel);
        }
        return result2;
    }

    private boolean hasNewVersion(@NotNull UpdateChannel channel) {
        if (channel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "com/intellij/openapi/updateSettings/impl/UpdateStrategy", "hasNewVersion"));
        }
        BuildInfo latestBuild = channel.getLatestBuild();
        return latestBuild != null && latestBuild.getNumber() != null && !this.myUpdateSettings.getIgnoredBuildNumbers().contains(latestBuild.getNumber().asStringWithoutProductCode()) && this.myCurrentBuild.compareTo(latestBuild.getNumber()) < 0;
    }

    private static boolean isBetter(UpdateChannel channelToPropose, UpdateChannel channel) {
        return channel.getMajorVersion() > channelToPropose.getMajorVersion() || channel.getMajorVersion() == channelToPropose.getMajorVersion() && channel.getStatus().compareTo(channelToPropose.getStatus()) > 0;
    }

    public static enum State {
        LOADED,
        CONNECTION_ERROR,
        NOTHING_LOADED;

    }
}

