/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.DiffRequestFromChange;
import com.intellij.openapi.vcs.changes.actions.ShowDiffAction;
import com.intellij.util.BeforeAfter;
import java.util.Collections;
import java.util.List;

public class BinaryDiffRequestFromChange
implements DiffRequestFromChange<DiffContent> {
    private final Project myProject;

    public BinaryDiffRequestFromChange(Project project) {
        this.myProject = project;
    }

    @Override
    public boolean canCreateRequest(Change change) {
        return ShowDiffAction.isBinaryChangeAndCanShow(this.myProject, change);
    }

    @Override
    public List<BeforeAfter<DiffContent>> createRequestForChange(Change change, int extraLines) throws VcsException {
        return Collections.singletonList(ShowDiffAction.createBinaryDiffContents(this.myProject, change));
    }
}

