/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowser;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTableModel;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.AsynchConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.ui.AdjustComponentWhenShown;
import java.awt.Component;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class ChangesBrowserDialog
extends DialogWrapper {
    private Project myProject;
    private CommittedChangesTableModel myChanges;
    private Mode myMode;
    private CommittedChangesBrowser myCommittedChangesBrowser;
    private AsynchConsumer<List<CommittedChangeList>> myAppender;
    private final Consumer<ChangesBrowserDialog> myInitRunnable;

    public ChangesBrowserDialog(Project project, CommittedChangesTableModel changes, Mode mode, Consumer<ChangesBrowserDialog> initRunnable) {
        super(project, true);
        this.myInitRunnable = initRunnable;
        this.initDialog(project, changes, mode);
    }

    public ChangesBrowserDialog(Project project, Component parent, CommittedChangesTableModel changes, Mode mode, Consumer<ChangesBrowserDialog> initRunnable) {
        super(parent, true);
        this.myInitRunnable = initRunnable;
        this.initDialog(project, changes, mode);
    }

    private void initDialog(Project project, CommittedChangesTableModel changes, Mode mode) {
        this.myProject = project;
        this.myChanges = changes;
        this.myMode = mode;
        this.setTitle(VcsBundle.message((String)"dialog.title.changes.browser", (Object[])new Object[0]));
        this.setCancelButtonText(CommonBundle.getCloseButtonText());
        ModalityState currentState = ModalityState.current();
        if (mode != Mode.Choose && ModalityState.NON_MODAL.equals(currentState)) {
            this.setModal(false);
        }
        this.myAppender = new AsynchConsumer<List<CommittedChangeList>>(){

            public void finished() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ChangesBrowserDialog.this.isShowing()) {
                            ChangesBrowserDialog.this.myCommittedChangesBrowser.stopLoading();
                        }
                    }
                });
            }

            public void consume(final List<CommittedChangeList> committedChangeLists) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ChangesBrowserDialog.this.isShowing()) {
                            boolean selectFirst = ChangesBrowserDialog.this.myChanges.getRowCount() == 0 && !committedChangeLists.isEmpty();
                            ChangesBrowserDialog.this.myChanges.addRows(committedChangeLists);
                            if (selectFirst) {
                                ChangesBrowserDialog.this.myCommittedChangesBrowser.selectFirstIfAny();
                            }
                        }
                    }
                });
            }
        };
        this.init();
        if (this.myInitRunnable != null) {
            new AdjustComponentWhenShown(){

                protected boolean init() {
                    ChangesBrowserDialog.this.myInitRunnable.consume((Object)ChangesBrowserDialog.this);
                    return true;
                }
            }.install((Component)this.myCommittedChangesBrowser);
        }
    }

    public AsynchConsumer<List<CommittedChangeList>> getAppender() {
        return this.myAppender;
    }

    public void startLoading() {
        this.myCommittedChangesBrowser.startLoading();
    }

    protected String getDimensionServiceKey() {
        return "VCS.ChangesBrowserDialog";
    }

    protected JComponent createCenterPanel() {
        this.myCommittedChangesBrowser = new CommittedChangesBrowser(this.myProject, this.myChanges);
        return this.myCommittedChangesBrowser;
    }

    protected void dispose() {
        super.dispose();
        this.myCommittedChangesBrowser.dispose();
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        if (this.myMode == Mode.Browse) {
            this.getOKAction().putValue("Name", VcsBundle.message((String)"button.search.again", (Object[])new Object[0]));
        }
    }

    @NotNull
    protected Action[] createActions() {
        if (this.myMode == Mode.Simple) {
            Action[] actionArray = new Action[]{this.getCancelAction()};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/committed/ChangesBrowserDialog", "createActions"));
            }
            return actionArray;
        }
        Action[] actionArray = super.createActions();
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/committed/ChangesBrowserDialog", "createActions"));
        }
        return actionArray;
    }

    public CommittedChangeList getSelectedChangeList() {
        return this.myCommittedChangesBrowser.getSelectedChangeList();
    }

    public static enum Mode {
        Simple,
        Browse,
        Choose;

    }
}

