/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictDialog;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ChangelistConflictAccessProvider
extends WritingAccessProvider {
    private final Project myProject;
    private final ChangeListManagerImpl myManager;

    public ChangelistConflictAccessProvider(Project project, ChangeListManagerImpl manager) {
        this.myProject = project;
        this.myManager = manager;
    }

    @NotNull
    public Collection<VirtualFile> requestWriting(VirtualFile ... files) {
        ChangelistConflictTracker.Options options = this.myManager.getConflictTracker().getOptions();
        if (!options.TRACKING_ENABLED || !options.SHOW_DIALOG) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictAccessProvider", "requestWriting"));
            }
            return list;
        }
        ArrayList<VirtualFile> denied = new ArrayList<VirtualFile>();
        for (VirtualFile file : files) {
            if (file == null || this.myManager.getConflictTracker().isWritingAllowed(file)) continue;
            denied.add(file);
        }
        if (!denied.isEmpty()) {
            ChangelistConflictDialog dialog;
            HashSet<LocalChangeList> changeLists = new HashSet<LocalChangeList>();
            ArrayList<Change> changes = new ArrayList<Change>();
            for (VirtualFile file : denied) {
                changeLists.add(this.myManager.getChangeList(file));
                changes.add(this.myManager.getChange(file));
            }
            int savedEventCount = IdeEventQueue.getInstance().getEventCount();
            do {
                dialog = new ChangelistConflictDialog(this.myProject, new ArrayList<ChangeList>(changeLists), denied);
                dialog.show();
            } while (dialog.isOK() && !dialog.getResolution().resolveConflict(this.myProject, changes));
            IdeEventQueue.getInstance().setEventCount(savedEventCount);
            if (dialog.isOK()) {
                options.LAST_RESOLUTION = dialog.getResolution();
                List<VirtualFile> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictAccessProvider", "requestWriting"));
                }
                return list;
            }
        }
        ArrayList<VirtualFile> arrayList = denied;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictAccessProvider", "requestWriting"));
        }
        return arrayList;
    }

    public boolean isPotentiallyWritable(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictAccessProvider", "isPotentiallyWritable"));
        }
        return true;
    }
}

