/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictNotificationPanel;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.annotations.NotNull;

public class ChangelistConflictNotificationProvider
extends EditorNotifications.Provider<ChangelistConflictNotificationPanel>
implements DumbAware {
    private static final Key<ChangelistConflictNotificationPanel> KEY = Key.create((String)"changelistConflicts");
    private final ChangelistConflictTracker myConflictTracker;

    public ChangelistConflictNotificationProvider(ChangeListManagerImpl changeListManager) {
        this.myConflictTracker = changeListManager.getConflictTracker();
    }

    @NotNull
    public Key<ChangelistConflictNotificationPanel> getKey() {
        Key<ChangelistConflictNotificationPanel> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictNotificationProvider", "getKey"));
        }
        return key;
    }

    public ChangelistConflictNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictNotificationProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictNotificationProvider", "createNotificationPanel"));
        }
        return this.myConflictTracker.hasConflict(file) ? ChangelistConflictNotificationPanel.create(this.myConflictTracker, file) : null;
    }
}

