/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelvedBinaryContentRevision
implements BinaryContentRevision {
    private final FilePath myPath;
    private final String myShelvedContentPath;

    public ShelvedBinaryContentRevision(FilePath path, String shelvedContentPath) {
        this.myPath = path;
        this.myShelvedContentPath = shelvedContentPath;
    }

    @Nullable
    public byte[] getBinaryContent() throws VcsException {
        try {
            return FileUtil.loadFileBytes((File)new File(this.myShelvedContentPath));
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
    }

    @Nullable
    public String getContent() throws VcsException {
        throw new IllegalStateException();
    }

    @NotNull
    public FilePath getFile() {
        FilePath filePath = this.myPath;
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelvedBinaryContentRevision", "getFile"));
        }
        return filePath;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        VcsRevisionNumber vcsRevisionNumber = new VcsRevisionNumber(){

            public String asString() {
                return VcsBundle.message((String)"shelved.version.name", (Object[])new Object[0]);
            }

            public int compareTo(VcsRevisionNumber o) {
                return -1;
            }
        };
        if (vcsRevisionNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelvedBinaryContentRevision", "getRevisionNumber"));
        }
        return vcsRevisionNumber;
    }
}

