/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CopyRevisionNumberAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/history/CopyRevisionNumberAction", "actionPerformed"));
        }
        List revisions = CopyRevisionNumberAction.getRevisionNumbersFromContext(e);
        revisions = ContainerUtil.reverse(revisions);
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(CopyRevisionNumberAction.getHashesAsString(revisions)));
    }

    @NotNull
    private static List<VcsRevisionNumber> getRevisionNumbersFromContext(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/history/CopyRevisionNumberAction", "getRevisionNumbersFromContext"));
        }
        VcsRevisionNumber[] revisionNumbers = (VcsRevisionNumber[])e.getData(VcsDataKeys.VCS_REVISION_NUMBERS);
        List<Object> list = revisionNumbers != null ? Arrays.asList(revisionNumbers) : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/CopyRevisionNumberAction", "getRevisionNumbersFromContext"));
        }
        return list;
    }

    @NotNull
    private static String getHashesAsString(@NotNull List<VcsRevisionNumber> revisions) {
        if (revisions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revisions", "com/intellij/openapi/vcs/history/CopyRevisionNumberAction", "getHashesAsString"));
        }
        String string = StringUtil.join(revisions, (Function)new Function<VcsRevisionNumber, String>(){

            public String fun(VcsRevisionNumber revision) {
                return revision.asString();
            }
        }, (String)" ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/CopyRevisionNumberAction", "getHashesAsString"));
        }
        return string;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/history/CopyRevisionNumberAction", "update"));
        }
        super.update(e);
        e.getPresentation().setEnabled(!CopyRevisionNumberAction.getRevisionNumbersFromContext(e).isEmpty());
    }
}

