/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.update.UpdateFilesHelper;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefreshVFsSynchronously {
    private static final Logger LOG = Logger.getInstance(RefreshVFsSynchronously.class);

    private RefreshVFsSynchronously() {
    }

    public static void updateAllChanged(@NotNull UpdatedFiles updatedFiles) {
        if (updatedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updatedFiles", "com/intellij/openapi/vcs/update/RefreshVFsSynchronously", "updateAllChanged"));
        }
        FilesToRefreshCollector callback = new FilesToRefreshCollector();
        UpdateFilesHelper.iterateFileGroupFilesDeletedOnServerFirst(updatedFiles, callback);
        RefreshVFsSynchronously.refreshDeletedOrReplaced(callback.getToRefreshDeletedOrReplaced());
        RefreshVFsSynchronously.refreshFiles(callback.getToRefresh());
    }

    public static void refreshFiles(@NotNull Collection<File> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/update/RefreshVFsSynchronously", "refreshFiles"));
        }
        HashSet filesToRefresh = ContainerUtil.newHashSet();
        for (File file : files) {
            VirtualFile vf = RefreshVFsSynchronously.findFirstValidVirtualParent(file);
            if (vf == null) continue;
            filesToRefresh.add(vf);
        }
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])((VirtualFile[])ArrayUtil.toObjectArray((Collection)filesToRefresh, VirtualFile.class)));
    }

    private static void refreshDeletedOrReplaced(@NotNull Collection<File> deletedOrReplaced) {
        if (deletedOrReplaced == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deletedOrReplaced", "com/intellij/openapi/vcs/update/RefreshVFsSynchronously", "refreshDeletedOrReplaced"));
        }
        HashSet filesToRefresh = ContainerUtil.newHashSet();
        for (File file : deletedOrReplaced) {
            File parent = file.getParentFile();
            VirtualFile vf = RefreshVFsSynchronously.findFirstValidVirtualParent(parent);
            if (vf == null) continue;
            filesToRefresh.add(vf);
        }
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])((VirtualFile[])ArrayUtil.toObjectArray((Collection)filesToRefresh, VirtualFile.class)));
    }

    @Nullable
    private static VirtualFile findFirstValidVirtualParent(@Nullable File file) {
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile vf = null;
        while (!(file == null || vf != null && vf.isValid())) {
            vf = lfs.findFileByIoFile(file);
            file = file.getParentFile();
        }
        return vf == null || !vf.isValid() ? null : vf;
    }

    public static void updateChangesForRollback(List<Change> changes) {
        RefreshVFsSynchronously.updateChangesImpl(changes, RollbackChangeWrapper.ourInstance);
    }

    public static void updateChanges(Collection<Change> changes) {
        RefreshVFsSynchronously.updateChangesImpl(changes, DirectChangeWrapper.ourInstance);
    }

    private static void updateChangesImpl(Collection<Change> changes, ChangeWrapper wrapper) {
        HashSet deletedOrReplaced = ContainerUtil.newHashSet();
        HashSet toRefresh = ContainerUtil.newHashSet();
        for (Change change : changes) {
            if (!wrapper.beforeNull(change) && (wrapper.movedOrRenamedOrReplaced(change) || wrapper.afterNull(change))) {
                deletedOrReplaced.add(wrapper.getBeforeFile(change));
            } else if (!wrapper.beforeNull(change)) {
                toRefresh.add(wrapper.getBeforeFile(change));
            }
            if (wrapper.afterNull(change) || !wrapper.beforeNull(change) && Comparing.equal((Object)change.getAfterRevision().getFile(), (Object)change.getBeforeRevision().getFile())) continue;
            toRefresh.add(wrapper.getAfterFile(change));
        }
        RefreshVFsSynchronously.refreshFiles(toRefresh);
        RefreshVFsSynchronously.refreshDeletedOrReplaced(deletedOrReplaced);
    }

    private static class FilesToRefreshCollector
    implements UpdateFilesHelper.Callback {
        private final Collection<File> myToRefresh = new THashSet();
        private final Collection<File> myToRefreshDeletedOrReplaced = new THashSet();

        private FilesToRefreshCollector() {
        }

        @Override
        public void onFile(String filePath, String groupId) {
            File file = new File(filePath);
            if ("REMOVED_FROM_REPOSITORY".equals(groupId) || "MERGED_WITH_TREE_CONFLICT".endsWith(groupId)) {
                this.myToRefreshDeletedOrReplaced.add(file);
            } else {
                this.myToRefresh.add(file);
            }
        }

        @NotNull
        public Collection<File> getToRefresh() {
            Collection<File> collection = this.myToRefresh;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/RefreshVFsSynchronously$FilesToRefreshCollector", "getToRefresh"));
            }
            return collection;
        }

        @NotNull
        public Collection<File> getToRefreshDeletedOrReplaced() {
            Collection<File> collection = this.myToRefreshDeletedOrReplaced;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/RefreshVFsSynchronously$FilesToRefreshCollector", "getToRefreshDeletedOrReplaced"));
            }
            return collection;
        }
    }

    private static interface ChangeWrapper {
        public boolean beforeNull(Change var1);

        public boolean afterNull(Change var1);

        @Nullable
        public File getBeforeFile(Change var1);

        @Nullable
        public File getAfterFile(Change var1);

        public boolean movedOrRenamedOrReplaced(Change var1);
    }

    private static class DirectChangeWrapper
    implements ChangeWrapper {
        private static final DirectChangeWrapper ourInstance = new DirectChangeWrapper();

        private DirectChangeWrapper() {
        }

        @Override
        public boolean beforeNull(Change change) {
            return change.getBeforeRevision() == null;
        }

        @Override
        public boolean afterNull(Change change) {
            return change.getAfterRevision() == null;
        }

        @Override
        @Nullable
        public File getBeforeFile(Change change) {
            return this.beforeNull(change) ? null : change.getBeforeRevision().getFile().getIOFile();
        }

        @Override
        @Nullable
        public File getAfterFile(Change change) {
            return this.afterNull(change) ? null : change.getAfterRevision().getFile().getIOFile();
        }

        @Override
        public boolean movedOrRenamedOrReplaced(Change change) {
            return change.isMoved() || change.isRenamed() || change.isIsReplaced();
        }
    }

    private static class RollbackChangeWrapper
    implements ChangeWrapper {
        private static final RollbackChangeWrapper ourInstance = new RollbackChangeWrapper();

        private RollbackChangeWrapper() {
        }

        @Override
        public boolean beforeNull(Change change) {
            return change.getAfterRevision() == null;
        }

        @Override
        public boolean afterNull(Change change) {
            return change.getBeforeRevision() == null;
        }

        @Override
        public File getBeforeFile(Change change) {
            return this.beforeNull(change) ? null : change.getAfterRevision().getFile().getIOFile();
        }

        @Override
        public File getAfterFile(Change change) {
            return this.afterNull(change) ? null : change.getBeforeRevision().getFile().getIOFile();
        }

        @Override
        public boolean movedOrRenamedOrReplaced(Change change) {
            return change.isMoved() || change.isRenamed() || change.isIsReplaced();
        }
    }
}

