/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project.model.impl.library;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.RootProviderBaseImpl;
import com.intellij.openapi.roots.impl.libraries.JarDirectories;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.project.model.impl.library.JpsLibraryTableImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsOrderRootType;

public class JpsLibraryDelegate
implements LibraryEx {
    private final JpsLibrary myJpsLibrary;
    private final JpsLibraryTableImpl myLibraryTable;
    private final Map<OrderRootType, VirtualFilePointerContainer> myRoots;
    private final RootProviderBaseImpl myRootProvider = new MyRootProvider();

    public JpsLibraryDelegate(JpsLibrary library, JpsLibraryTableImpl table) {
        this.myJpsLibrary = library;
        this.myLibraryTable = table;
        this.myRoots = new HashMap<OrderRootType, VirtualFilePointerContainer>();
    }

    public String getName() {
        return this.myJpsLibrary.getName();
    }

    public PersistentLibraryKind<?> getKind() {
        return null;
    }

    public LibraryProperties getProperties() {
        return null;
    }

    @NotNull
    public String[] getUrls(@NotNull OrderRootType rootType) {
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/project/model/impl/library/JpsLibraryDelegate", "getUrls"));
        }
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        if (container == null) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/library/JpsLibraryDelegate", "getUrls"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = container.getUrls();
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/library/JpsLibraryDelegate", "getUrls"));
        }
        return stringArray;
    }

    @NotNull
    public VirtualFile[] getFiles(@NotNull OrderRootType rootType) {
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/project/model/impl/library/JpsLibraryDelegate", "getFiles"));
        }
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        if (container == null) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/library/JpsLibraryDelegate", "getFiles"));
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        ArrayList<VirtualFile> expanded = new ArrayList<VirtualFile>();
        for (JpsLibraryRoot root : this.myJpsLibrary.getRoots(JpsLibraryDelegate.getJpsRootType(rootType))) {
            VirtualFile file;
            VirtualFilePointer pointer = container.findByUrl(root.getUrl());
            if (pointer == null || (file = pointer.getFile()) == null) continue;
            if (file.isDirectory() && root.getInclusionOptions() != JpsLibraryRoot.InclusionOptions.ROOT_ITSELF) {
                LibraryImpl.collectJarFiles(file, expanded, root.getInclusionOptions() == JpsLibraryRoot.InclusionOptions.ARCHIVES_UNDER_ROOT_RECURSIVELY);
                continue;
            }
            expanded.add(file);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(expanded);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/library/JpsLibraryDelegate", "getFiles"));
        }
        return virtualFileArray;
    }

    public List<String> getInvalidRootUrls(OrderRootType type) {
        VirtualFilePointerContainer container = this.myRoots.get(type);
        if (container == null) {
            return Collections.emptyList();
        }
        List pointers = container.getList();
        SmartList invalidPaths = null;
        for (VirtualFilePointer pointer : pointers) {
            if (pointer.isValid()) continue;
            if (invalidPaths == null) {
                invalidPaths = new SmartList();
            }
            invalidPaths.add(pointer.getUrl());
        }
        return invalidPaths == null ? Collections.emptyList() : invalidPaths;
    }

    public boolean isDisposed() {
        return false;
    }

    public LibraryTable getTable() {
        return this.myLibraryTable;
    }

    @NotNull
    public RootProvider getRootProvider() {
        RootProviderBaseImpl rootProviderBaseImpl = this.myRootProvider;
        if (rootProviderBaseImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/library/JpsLibraryDelegate", "getRootProvider"));
        }
        return rootProviderBaseImpl;
    }

    public void dispose() {
    }

    @NotNull
    public LibraryEx.ModifiableModelEx getModifiableModel() {
        throw new UnsupportedOperationException("'getModifiableModel' not implemented in " + this.getClass().getName());
    }

    @NotNull
    public String[] getExcludedRootUrls() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/library/JpsLibraryDelegate", "getExcludedRootUrls"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @NotNull
    public VirtualFile[] getExcludedRoots() {
        if (VirtualFile.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/library/JpsLibraryDelegate", "getExcludedRoots"));
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    public void readExternal(Element element) throws InvalidDataException {
        throw new UnsupportedOperationException();
    }

    public void writeExternal(Element element) throws WriteExternalException {
        throw new UnsupportedOperationException();
    }

    public boolean isJarDirectory(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/project/model/impl/library/JpsLibraryDelegate", "isJarDirectory"));
        }
        return this.isJarDirectory(url, JarDirectories.DEFAULT_JAR_DIRECTORY_TYPE);
    }

    public boolean isJarDirectory(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/project/model/impl/library/JpsLibraryDelegate", "isJarDirectory"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/project/model/impl/library/JpsLibraryDelegate", "isJarDirectory"));
        }
        for (JpsLibraryRoot root : this.myJpsLibrary.getRoots(JpsLibraryDelegate.getJpsRootType(rootType))) {
            if (!url.equals(root.getUrl()) || root.getInclusionOptions() == JpsLibraryRoot.InclusionOptions.ROOT_ITSELF) continue;
            return true;
        }
        return false;
    }

    public boolean isValid(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/project/model/impl/library/JpsLibraryDelegate", "isValid"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/project/model/impl/library/JpsLibraryDelegate", "isValid"));
        }
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        if (container == null) {
            return false;
        }
        VirtualFilePointer fp = container.findByUrl(url);
        return fp != null && fp.isValid();
    }

    private static JpsOrderRootType getJpsRootType(OrderRootType type) {
        if (type == OrderRootType.CLASSES) {
            return JpsOrderRootType.COMPILED;
        }
        if (type == OrderRootType.SOURCES) {
            return JpsOrderRootType.SOURCES;
        }
        if (type == OrderRootType.DOCUMENTATION) {
            return JpsOrderRootType.DOCUMENTATION;
        }
        return JpsOrderRootType.COMPILED;
    }

    private class MyRootProvider
    extends RootProviderBaseImpl {
        private MyRootProvider() {
        }

        @NotNull
        public String[] getUrls(@NotNull OrderRootType rootType) {
            if (rootType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/project/model/impl/library/JpsLibraryDelegate$MyRootProvider", "getUrls"));
            }
            LinkedHashSet<String> originalUrls = new LinkedHashSet<String>(Arrays.asList(JpsLibraryDelegate.this.getUrls(rootType)));
            for (VirtualFile file : this.getFiles(rootType)) {
                originalUrls.add(file.getUrl());
            }
            String[] stringArray = ArrayUtil.toStringArray(originalUrls);
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/library/JpsLibraryDelegate$MyRootProvider", "getUrls"));
            }
            return stringArray;
        }

        @NotNull
        public VirtualFile[] getFiles(@NotNull OrderRootType rootType) {
            if (rootType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/project/model/impl/library/JpsLibraryDelegate$MyRootProvider", "getFiles"));
            }
            VirtualFile[] virtualFileArray = JpsLibraryDelegate.this.getFiles(rootType);
            if (virtualFileArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/library/JpsLibraryDelegate$MyRootProvider", "getFiles"));
            }
            return virtualFileArray;
        }
    }
}

