/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.projectImport;

import com.intellij.ide.util.newProjectWizard.StepSequence;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportBuilder;
import javax.swing.Icon;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectImportProvider {
    public static final ExtensionPointName<ProjectImportProvider> PROJECT_IMPORT_PROVIDER = ExtensionPointName.create((String)"com.intellij.projectImportProvider");
    protected ProjectImportBuilder myBuilder;

    protected ProjectImportProvider(ProjectImportBuilder builder) {
        this.myBuilder = builder;
    }

    public ProjectImportBuilder getBuilder() {
        return this.myBuilder;
    }

    @NonNls
    @NotNull
    public String getId() {
        String string = this.getBuilder().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/projectImport/ProjectImportProvider", "getId"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.getBuilder().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/projectImport/ProjectImportProvider", "getName"));
        }
        return string;
    }

    @Nullable
    public Icon getIcon() {
        return this.getBuilder().getIcon();
    }

    public boolean canImport(@NotNull VirtualFile fileOrDirectory, @Nullable Project project) {
        if (fileOrDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDirectory", "com/intellij/projectImport/ProjectImportProvider", "canImport"));
        }
        if (fileOrDirectory.isDirectory()) {
            return true;
        }
        return this.canImportFromFile(fileOrDirectory);
    }

    protected boolean canImportFromFile(VirtualFile file) {
        return false;
    }

    public String getPathToBeImported(VirtualFile file) {
        return ProjectImportProvider.getDefaultPath(file);
    }

    public static String getDefaultPath(VirtualFile file) {
        return file.isDirectory() ? file.getPath() : file.getParent().getPath();
    }

    public boolean canCreateNewProject() {
        return true;
    }

    public boolean canImportModule() {
        return true;
    }

    public void addSteps(StepSequence sequence, WizardContext context, String id) {
        ModuleWizardStep[] steps;
        for (ModuleWizardStep step : steps = this.createSteps(context)) {
            sequence.addSpecificStep(id, step);
        }
    }

    public ModuleWizardStep[] createSteps(WizardContext context) {
        return ModuleWizardStep.EMPTY_ARRAY;
    }

    @Nullable
    @Language(value="HTML")
    public String getFileSample() {
        return null;
    }
}

