/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.projectImport;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.projectImport.ProjectImportWizardStep;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SelectImportedProjectsStep<T>
extends ProjectImportWizardStep {
    private final JPanel panel;
    protected final ElementsChooser<T> fileChooser = new ElementsChooser<T>(true){

        @Override
        protected String getItemText(@NotNull T item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/projectImport/SelectImportedProjectsStep$1", "getItemText"));
            }
            return SelectImportedProjectsStep.this.getElementText(item);
        }

        @Override
        protected Icon getItemIcon(@NotNull T item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/projectImport/SelectImportedProjectsStep$1", "getItemIcon"));
            }
            return SelectImportedProjectsStep.this.getElementIcon(item);
        }
    };
    private final JCheckBox openModuleSettingsCheckBox;

    public SelectImportedProjectsStep(WizardContext context) {
        super(context);
        this.panel = new JPanel((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.panel.add(this.fileChooser, new GridConstraints(0, 0, 1, 1, 1, 3, 5, 5, null, null, null));
        AnAction selectAllAction = new AnAction(RefactoringBundle.message((String)"select.all.button")){

            public void actionPerformed(AnActionEvent e) {
                SelectImportedProjectsStep.this.fileChooser.setAllElementsMarked(true);
            }
        };
        AnAction unselectAllAction = new AnAction(RefactoringBundle.message((String)"unselect.all.button")){

            public void actionPerformed(AnActionEvent e) {
                SelectImportedProjectsStep.this.fileChooser.setAllElementsMarked(false);
            }
        };
        JComponent actionToolbar = ActionManager.getInstance().createButtonToolbar("unknown", (ActionGroup)new DefaultActionGroup(new AnAction[]{selectAllAction, unselectAllAction}));
        this.panel.add((Component)actionToolbar, new GridConstraints(1, 0, 1, 1, 1, 1, 5, 1, null, null, null));
        this.openModuleSettingsCheckBox = new JCheckBox(IdeBundle.message((String)"project.import.show.settings.after", (Object[])new Object[0]));
        this.panel.add((Component)this.openModuleSettingsCheckBox, new GridConstraints(2, 0, 1, 1, 2, 1, 5, 0, null, null, null));
    }

    @Nullable
    protected Icon getElementIcon(T item) {
        return null;
    }

    protected abstract String getElementText(T var1);

    public JComponent getComponent() {
        return this.panel;
    }

    protected boolean isElementEnabled(T element) {
        return true;
    }

    public void updateStep() {
        this.fileChooser.clear();
        Iterator<T> iterator = this.getContext().getList().iterator();
        while (iterator.hasNext()) {
            T element;
            boolean isEnabled = this.isElementEnabled(element = iterator.next());
            this.fileChooser.addElement(element, isEnabled && this.getContext().isMarked(element));
            if (isEnabled) continue;
            this.fileChooser.disableElement(element);
        }
        this.fileChooser.setBorder((Border)IdeBorderFactory.createTitledBorder((String)IdeBundle.message((String)"project.import.select.title", (Object[])new Object[]{this.getContext().getName()}), (boolean)false));
        this.openModuleSettingsCheckBox.setSelected(this.getBuilder().isOpenProjectSettingsAfter());
    }

    public boolean validate() throws ConfigurationException {
        this.getContext().setList(this.fileChooser.getMarkedElements());
        if (this.fileChooser.getMarkedElements().size() == 0) {
            throw new ConfigurationException("Nothing found to import", "Unable to proceed");
        }
        return true;
    }

    public void updateDataModel() {
    }

    public void onStepLeaving() {
        super.onStepLeaving();
        this.getContext().setOpenProjectSettingsAfter(this.openModuleSettingsCheckBox.isSelected());
    }

    public ProjectImportBuilder<T> getContext() {
        return this.getBuilder();
    }
}

