/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.autodetect;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.EditorNotificationInfo;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetectedIndentOptionsNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"indent.options.notification.provider");
    private static final Key<Boolean> NOTIFIED_FLAG = Key.create((String)"indent.options.notification.provider.status");
    protected static final Key<Boolean> DETECT_INDENT_NOTIFICATION_SHOWN_KEY = Key.create((String)"indent.options.notification.provider.status.test.notification.shown");
    private static boolean myShowNotificationInTest = false;

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/autodetect/DetectedIndentOptionsNotificationProvider", "getKey"));
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        Editor editor;
        Project project;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/autodetect/DetectedIndentOptionsNotificationProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/psi/codeStyle/autodetect/DetectedIndentOptionsNotificationProvider", "createNotificationPanel"));
        }
        Boolean notifiedFlag = (Boolean)fileEditor.getUserData(NOTIFIED_FLAG);
        if (fileEditor instanceof TextEditor && notifiedFlag != null && (project = (editor = ((TextEditor)fileEditor).getEditor()).getProject()) != null) {
            Document document = editor.getDocument();
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            PsiFile psiFile = documentManager.getPsiFile(document);
            final Ref indentOptionsProviderRef = new Ref();
            if (psiFile != null) {
                EditorNotificationInfo info;
                CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)project);
                CommonCodeStyleSettings.IndentOptions userOptions = settings.getIndentOptions(psiFile.getFileType());
                CommonCodeStyleSettings.IndentOptions detectedOptions = CodeStyleSettingsManager.getSettings((Project)project).getIndentOptionsByFile(psiFile, null, false, (Processor)new Processor<FileIndentOptionsProvider>(){

                    public boolean process(FileIndentOptionsProvider provider) {
                        indentOptionsProviderRef.set((Object)provider);
                        return false;
                    }
                });
                FileIndentOptionsProvider provider = (FileIndentOptionsProvider)indentOptionsProviderRef.get();
                EditorNotificationInfo editorNotificationInfo = info = provider != null && !provider.isAcceptedWithoutWarning(project, file) && !userOptions.equals((Object)detectedOptions) ? provider.getNotificationInfo(project, file, fileEditor, userOptions, detectedOptions) : null;
                if (info != null) {
                    EditorNotificationPanel panel = new EditorNotificationPanel().text(info.getTitle());
                    if (info.getIcon() != null) {
                        panel.icon(info.getIcon());
                    }
                    for (final EditorNotificationInfo.ActionLabelData actionLabelData : info.getLabelAndActions()) {
                        Runnable onClickAction = new Runnable(){

                            @Override
                            public void run() {
                                actionLabelData.action.run();
                                EditorNotifications.getInstance((Project)project).updateAllNotifications();
                            }
                        };
                        panel.createActionLabel(actionLabelData.label, onClickAction);
                    }
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        file.putUserData(DETECT_INDENT_NOTIFICATION_SHOWN_KEY, (Object)Boolean.TRUE);
                    }
                    return panel;
                }
            }
        }
        return null;
    }

    public static void updateIndentNotification(@NotNull PsiFile file, boolean enforce) {
        Boolean notifiedFlag;
        Project project;
        FileEditorManager fileEditorManager;
        FileEditor fileEditor;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/autodetect/DetectedIndentOptionsNotificationProvider", "updateIndentNotification"));
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            return;
        }
        if ((!ApplicationManager.getApplication().isHeadlessEnvironment() || ApplicationManager.getApplication().isUnitTestMode() && myShowNotificationInTest) && (fileEditor = (fileEditorManager = FileEditorManager.getInstance((Project)(project = file.getProject()))).getSelectedEditor(vFile)) != null && ((notifiedFlag = (Boolean)fileEditor.getUserData(NOTIFIED_FLAG)) == null || enforce)) {
            fileEditor.putUserData(NOTIFIED_FLAG, (Object)Boolean.TRUE);
            EditorNotifications.getInstance((Project)project).updateNotifications(vFile);
        }
    }

    static void setShowNotificationInTest(boolean show) {
        myShowNotificationInTest = show;
    }
}

