/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.beanProperties;

import com.intellij.icons.AllIcons;
import com.intellij.ide.presentation.Presentation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(icon="AllIcons.Nodes.Property")
public class BeanProperty {
    private final PsiMethod myMethod;

    protected BeanProperty(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/beanProperties/BeanProperty", "<init>"));
        }
        this.myMethod = method;
    }

    public PsiNamedElement getPsiElement() {
        return new BeanPropertyElement(this.myMethod, this.getName()){

            @Override
            public PsiType getPropertyType() {
                return BeanProperty.this.getPropertyType();
            }
        };
    }

    @NotNull
    public String getName() {
        String name = PropertyUtil.getPropertyName((PsiMethod)this.myMethod);
        String string = name == null ? "" : name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/beanProperties/BeanProperty", "getName"));
        }
        return string;
    }

    @NotNull
    public PsiType getPropertyType() {
        PsiType type = PropertyUtil.getPropertyType((PsiMember)this.myMethod);
        assert (type != null);
        PsiType psiType = type;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/beanProperties/BeanProperty", "getPropertyType"));
        }
        return psiType;
    }

    @NotNull
    public PsiMethod getMethod() {
        PsiMethod psiMethod = this.myMethod;
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/beanProperties/BeanProperty", "getMethod"));
        }
        return psiMethod;
    }

    @Nullable
    public PsiMethod getGetter() {
        if (PropertyUtil.isSimplePropertyGetter((PsiMethod)this.myMethod)) {
            return this.myMethod;
        }
        return PropertyUtil.findPropertyGetter((PsiClass)this.myMethod.getContainingClass(), (String)this.getName(), (boolean)false, (boolean)true);
    }

    @Nullable
    public PsiMethod getSetter() {
        if (PropertyUtil.isSimplePropertySetter((PsiMethod)this.myMethod)) {
            return this.myMethod;
        }
        return PropertyUtil.findPropertySetter((PsiClass)this.myMethod.getContainingClass(), (String)this.getName(), (boolean)false, (boolean)true);
    }

    public void setName(String newName) throws IncorrectOperationException {
        PsiMethod setter = this.getSetter();
        PsiMethod getter = this.getGetter();
        if (getter != null) {
            String getterName = PropertyUtil.suggestGetterName((String)newName, (PsiType)getter.getReturnType());
            getter.setName(getterName);
        }
        if (setter != null) {
            String setterName = PropertyUtil.suggestSetterName((String)newName);
            setter.setName(setterName);
        }
    }

    @Nullable
    public Icon getIcon(int flags) {
        return AllIcons.Nodes.Property;
    }

    @Nullable
    public static BeanProperty createBeanProperty(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/beanProperties/BeanProperty", "createBeanProperty"));
        }
        return PropertyUtil.isSimplePropertyAccessor((PsiMethod)method) ? new BeanProperty(method) : null;
    }
}

