/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache;

import com.intellij.util.ArrayUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntObjectHashMap;
import org.jetbrains.annotations.Nullable;

public class SmartIntToIntArrayMap {
    @Nullable
    TIntObjectHashMap<TIntArrayList> myMultipleValuesMap = null;
    TIntIntHashMap mySingleValueMap = new TIntIntHashMap(10, 0.9f);

    public int[] keys() {
        int[] multiKeys = this.myMultipleValuesMap != null ? this.myMultipleValuesMap.keys() : ArrayUtil.EMPTY_INT_ARRAY;
        int[] singleKeys = this.mySingleValueMap.keys();
        if (singleKeys.length == 0) {
            return multiKeys;
        }
        int[] combinedKeys = new int[multiKeys.length + singleKeys.length];
        System.arraycopy(multiKeys, 0, combinedKeys, 0, multiKeys.length);
        System.arraycopy(singleKeys, 0, combinedKeys, multiKeys.length, singleKeys.length);
        return combinedKeys;
    }

    public void addOccurence(int key, int value) {
        if (this.myMultipleValuesMap != null && this.myMultipleValuesMap.containsKey(key)) {
            this.addToMultimap(key, value);
        } else if (this.mySingleValueMap.containsKey(key)) {
            int storedId = this.mySingleValueMap.get(key);
            if (storedId == value) {
                return;
            }
            this.mySingleValueMap.remove(key);
            this.addToMultimap(key, storedId);
            this.addToMultimap(key, value);
        } else {
            this.mySingleValueMap.put(key, value);
        }
    }

    private void addToMultimap(int key, int value) {
        TIntObjectHashMap<TIntArrayList> map;
        TIntArrayList list;
        if (this.myMultipleValuesMap == null) {
            this.myMultipleValuesMap = new TIntObjectHashMap(10, 0.9f);
        }
        if ((list = (TIntArrayList)(map = this.myMultipleValuesMap).get(key)) == null) {
            list = new TIntArrayList(3);
            map.put(key, (Object)list);
        }
        if (!list.contains(value)) {
            list.add(value);
        }
    }

    public void removeOccurence(int key, int value) {
        if (this.mySingleValueMap.containsKey(key)) {
            this.mySingleValueMap.remove(key);
        } else {
            this.removeFromMultiMap(key, value);
        }
    }

    private void removeFromMultiMap(int key, int value) {
        int offset;
        TIntObjectHashMap<TIntArrayList> map = this.myMultipleValuesMap;
        if (map == null) {
            return;
        }
        TIntArrayList list = (TIntArrayList)map.get(key);
        if (list != null && (offset = list.indexOf(value)) != -1) {
            list.remove(offset);
            if (list.isEmpty()) {
                map.remove(key);
            }
        }
    }

    public int[] get(int key) {
        if (this.mySingleValueMap.containsKey(key)) {
            int id = this.mySingleValueMap.get(key);
            return new int[]{id};
        }
        return this.getFromMultimap(key);
    }

    private int[] getFromMultimap(int key) {
        TIntArrayList res;
        TIntArrayList tIntArrayList = res = this.myMultipleValuesMap != null ? (TIntArrayList)this.myMultipleValuesMap.get(key) : null;
        if (res == null) {
            return ArrayUtil.EMPTY_INT_ARRAY;
        }
        return res.toNativeArray();
    }
}

