/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiDelegateReference
implements PsiReference {
    private final PsiReference myDelegate;

    public PsiDelegateReference(@NotNull PsiReference delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/psi/impl/source/resolve/reference/impl/PsiDelegateReference", "<init>"));
        }
        this.myDelegate = delegate;
    }

    public PsiElement getElement() {
        return this.myDelegate.getElement();
    }

    public TextRange getRangeInElement() {
        return this.myDelegate.getRangeInElement();
    }

    @Nullable
    public PsiElement resolve() {
        return this.myDelegate.resolve();
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myDelegate.getCanonicalText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/PsiDelegateReference", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return this.myDelegate.handleElementRename(newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/PsiDelegateReference", "bindToElement"));
        }
        return this.myDelegate.bindToElement(element);
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.myDelegate.isReferenceTo(element);
    }

    @NotNull
    public Object[] getVariants() {
        Object[] objectArray = this.myDelegate.getVariants();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/PsiDelegateReference", "getVariants"));
        }
        return objectArray;
    }

    public boolean isSoft() {
        return this.myDelegate.isSoft();
    }

    public static PsiReference createSoft(PsiReference origin, final boolean soft) {
        return new PsiDelegateReference(origin){

            @Override
            public boolean isSoft() {
                return soft;
            }
        };
    }
}

