/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URIReferenceProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class XmlBaseReferenceProvider
extends PsiReferenceProvider {
    private final boolean myAcceptSelf;

    public XmlBaseReferenceProvider(boolean acceptSelf) {
        this.myAcceptSelf = acceptSelf;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(final @NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/XmlBaseReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/impl/providers/XmlBaseReferenceProvider", "getReferencesByElement"));
        }
        PsiReference reference = URIReferenceProvider.getUrlReference(element, ElementManipulators.getValueText((PsiElement)element));
        if (reference != null) {
            PsiReference[] psiReferenceArray = new PsiReference[]{reference};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/XmlBaseReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        FileReferenceSet referenceSet = FileReferenceSet.createSet(element, false, false, false);
        referenceSet.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, new Function<PsiFile, Collection<PsiFileSystemItem>>(){

            public Collection<PsiFileSystemItem> fun(PsiFile file) {
                return XmlBaseReferenceProvider.this.getContext(element, file);
            }
        });
        PsiReference[] psiReferenceArray = referenceSet.getAllReferences();
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/XmlBaseReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    private Collection<PsiFileSystemItem> getContext(PsiElement element, PsiFile file) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        if (!this.myAcceptSelf && tag != null) {
            tag = tag.getParentTag();
        }
        while (tag != null) {
            PsiReference reference;
            XmlAttributeValue value;
            XmlAttribute base = tag.getAttribute("base", "http://www.w3.org/XML/1998/namespace");
            if (base != null && (value = base.getValueElement()) != null && (reference = value.getReference()) instanceof PsiPolyVariantReference) {
                Object[] results = ((PsiPolyVariantReference)reference).multiResolve(false);
                return ContainerUtil.map((Object[])results, (Function)new Function<ResolveResult, PsiFileSystemItem>(){

                    public PsiFileSystemItem fun(ResolveResult result2) {
                        return (PsiFileSystemItem)result2.getElement();
                    }
                });
            }
            tag = tag.getParentTag();
        }
        PsiDirectory directory = file.getContainingDirectory();
        return directory == null ? Collections.emptyList() : Collections.singletonList(directory);
    }
}

